<?php
// Activer les erreurs pour le debug
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once __DIR__ . '/config.php';

$error = '';
$success = '';
$debug = []; // Pour débugger

// Traitement du formulaire de création de partie
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    $debug[] = "POST reçu: action=" . $_POST['action'];
    
    if ($_POST['action'] === 'create') {
        $debug[] = "Création de partie...";
        $playerName = trim($_POST['player_name'] ?? '');
        
        if (empty($playerName)) {
            $error = 'Veuillez entrer votre nom';
        } elseif (strlen($playerName) > 20) {
            $error = 'Le nom doit faire moins de 20 caractères';
        } else {
            // Générer un code unique
            do {
                $code = generateGameCode();
            } while (file_exists(getGameFilePath($code)));
            
            $debug[] = "Code généré: $code";
            
            // Créer le joueur
            $playerId = uniqid('player_', true);
            
            // Créer la partie
            $game = [
                'code' => $code,
                'status' => 'waiting', // waiting, playing, voting, ended
                'phase' => 'lobby',    // lobby, description, discussion, voting, reveal
                'round' => 0,
                'host' => $playerId,
                'players' => [
                    $playerId => [
                        'id' => $playerId,
                        'name' => htmlspecialchars($playerName),
                        'role' => null,
                        'word' => null,
                        'alive' => true,
                        'hasDescribed' => false,
                        'votes' => 0,
                        'votedFor' => null,
                        'joinedAt' => time()
                    ]
                ],
                'wordPair' => null,
                'currentPlayer' => null,
                'descriptionOrder' => [],
                'currentDescriber' => 0,
                'eliminatedPlayer' => null,
                'winner' => null,
                'mrWhiteGuess' => null,
                'createdAt' => time(),
                'updatedAt' => time()
            ];
            
            $saved = saveGame($code, $game);
            $debug[] = "Partie sauvegardée: " . ($saved ? 'oui' : 'non');
            $debug[] = "Chemin fichier: " . getGameFilePath($code);
            
            if (!$saved) {
                $error = "Erreur: Impossible de créer la partie. Vérifiez les permissions du dossier games/";
            } else {
                // Sauvegarder dans la session
                $_SESSION['player_id'] = $playerId;
                $_SESSION['game_code'] = $code;
                $_SESSION['player_name'] = $playerName;
                
                $debug[] = "Session créée, redirection...";
                
                // Redirection JavaScript en cas de problème avec header
                echo "<script>window.location.href = 'game.php';</script>";
                echo "<meta http-equiv='refresh' content='0;url=game.php'>";
                exit;
            }
        }
    }
    
    if ($_POST['action'] === 'join') {
        $playerName = trim($_POST['player_name'] ?? '');
        $code = strtoupper(trim($_POST['game_code'] ?? ''));
        
        if (empty($playerName)) {
            $error = 'Veuillez entrer votre nom';
        } elseif (strlen($playerName) > 20) {
            $error = 'Le nom doit faire moins de 20 caractères';
        } elseif (empty($code)) {
            $error = 'Veuillez entrer le code de la partie';
        } else {
            $game = loadGame($code);
            
            if (!$game) {
                $error = 'Partie non trouvée. Vérifiez le code.';
            } elseif ($game['status'] !== 'waiting') {
                $error = 'Cette partie a déjà commencé';
            } elseif (count($game['players']) >= 20) {
                $error = 'Cette partie est complète (20 joueurs max)';
            } else {
                // Vérifier si le nom est déjà pris
                $nameTaken = false;
                foreach ($game['players'] as $p) {
                    if (strtolower($p['name']) === strtolower($playerName)) {
                        $nameTaken = true;
                        break;
                    }
                }
                
                if ($nameTaken) {
                    $error = 'Ce nom est déjà pris dans cette partie';
                } else {
                    // Ajouter le joueur
                    $playerId = uniqid('player_', true);
                    $game['players'][$playerId] = [
                        'id' => $playerId,
                        'name' => htmlspecialchars($playerName),
                        'role' => null,
                        'word' => null,
                        'alive' => true,
                        'hasDescribed' => false,
                        'votes' => 0,
                        'votedFor' => null,
                        'joinedAt' => time()
                    ];
                    $game['updatedAt'] = time();
                    
                    saveGame($code, $game);
                    
                    // Sauvegarder dans la session
                    $_SESSION['player_id'] = $playerId;
                    $_SESSION['game_code'] = $code;
                    $_SESSION['player_name'] = $playerName;
                    
                    header('Location: game.php');
                    exit;
                }
            }
        }
    }
}

// Vérifier si le joueur est déjà dans une partie
if (isset($_SESSION['game_code']) && isset($_SESSION['player_id'])) {
    $existingGame = loadGame($_SESSION['game_code']);
    if ($existingGame && isset($existingGame['players'][$_SESSION['player_id']])) {
        header('Location: game.php');
        exit;
    } else {
        // Nettoyer la session si la partie n'existe plus
        unset($_SESSION['game_code'], $_SESSION['player_id'], $_SESSION['player_name']);
    }
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Undercover - Jeu de mots entre amis</title>
    <style>
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }
        
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, sans-serif;
            background: linear-gradient(135deg, #1a1a2e 0%, #16213e 50%, #0f3460 100%);
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            padding: 20px;
            color: #fff;
        }
        
        .container {
            width: 100%;
            max-width: 400px;
        }
        
        .logo {
            text-align: center;
            margin-bottom: 30px;
        }
        
        .logo h1 {
            font-size: 3rem;
            background: linear-gradient(45deg, #e94560, #ff6b6b);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            text-shadow: 0 0 30px rgba(233, 69, 96, 0.5);
        }
        
        .logo p {
            color: #aaa;
            margin-top: 5px;
        }
        
        .tabs {
            display: flex;
            margin-bottom: 20px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 15px;
            padding: 5px;
        }
        
        .tab {
            flex: 1;
            padding: 15px;
            text-align: center;
            border-radius: 12px;
            cursor: pointer;
            transition: all 0.3s;
            font-weight: 600;
            color: #aaa;
        }
        
        .tab.active {
            background: linear-gradient(45deg, #e94560, #ff6b6b);
            color: #fff;
            box-shadow: 0 5px 20px rgba(233, 69, 96, 0.4);
        }
        
        .tab:hover:not(.active) {
            color: #fff;
        }
        
        .form-container {
            background: rgba(255, 255, 255, 0.05);
            border-radius: 20px;
            padding: 30px;
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.1);
        }
        
        .form-panel {
            display: none;
        }
        
        .form-panel.active {
            display: block;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 8px;
            font-weight: 500;
            color: #ddd;
        }
        
        .form-group input {
            width: 100%;
            padding: 15px;
            border: 2px solid rgba(255, 255, 255, 0.1);
            border-radius: 12px;
            background: rgba(255, 255, 255, 0.05);
            color: #fff;
            font-size: 1rem;
            transition: all 0.3s;
        }
        
        .form-group input:focus {
            outline: none;
            border-color: #e94560;
            background: rgba(255, 255, 255, 0.1);
        }
        
        .form-group input::placeholder {
            color: #666;
        }
        
        .btn {
            width: 100%;
            padding: 15px;
            border: none;
            border-radius: 12px;
            font-size: 1.1rem;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
        }
        
        .btn-primary {
            background: linear-gradient(45deg, #e94560, #ff6b6b);
            color: #fff;
            box-shadow: 0 5px 20px rgba(233, 69, 96, 0.4);
        }
        
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(233, 69, 96, 0.5);
        }
        
        .btn-primary:active {
            transform: translateY(0);
        }
        
        .error {
            background: rgba(220, 53, 69, 0.2);
            border: 1px solid #dc3545;
            color: #ff6b6b;
            padding: 12px;
            border-radius: 10px;
            margin-bottom: 20px;
            text-align: center;
        }
        
        .roles-info {
            margin-top: 30px;
            padding: 20px;
            background: rgba(255, 255, 255, 0.05);
            border-radius: 15px;
        }
        
        .roles-info h3 {
            text-align: center;
            margin-bottom: 15px;
            color: #e94560;
        }
        
        .role {
            display: flex;
            align-items: center;
            padding: 10px 0;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }
        
        .role:last-child {
            border-bottom: none;
        }
        
        .role-icon {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 15px;
            font-size: 1.2rem;
        }
        
        .role-civilian .role-icon {
            background: linear-gradient(45deg, #28a745, #20c997);
        }
        
        .role-undercover .role-icon {
            background: linear-gradient(45deg, #dc3545, #e94560);
        }
        
        .role-mrwhite .role-icon {
            background: linear-gradient(45deg, #6c757d, #adb5bd);
        }
        
        .role-text h4 {
            font-size: 0.95rem;
            margin-bottom: 3px;
        }
        
        .role-text p {
            font-size: 0.8rem;
            color: #aaa;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="logo">
            <h1>🕵️ Undercover</h1>
            <p>Jeu de mots entre amis</p>
        </div>
        
        <div class="tabs">
            <div class="tab active" onclick="showTab('create')">Créer</div>
            <div class="tab" onclick="showTab('join')">Rejoindre</div>
        </div>
        
        <div class="form-container">
            <?php if ($error): ?>
                <div class="error"><?= htmlspecialchars($error) ?></div>
            <?php endif; ?>
            
            <?php if (!empty($debug)): ?>
                <div class="error" style="background: rgba(0,100,200,0.2); border-color: #0066cc; color: #66aaff;">
                    <strong>Debug:</strong><br>
                    <?= implode('<br>', array_map('htmlspecialchars', $debug)) ?>
                </div>
            <?php endif; ?>
            
            <!-- Formulaire de création -->
            <div class="form-panel active" id="create-panel">
                <form method="POST">
                    <input type="hidden" name="action" value="create">
                    
                    <div class="form-group">
                        <label for="create-name">Votre nom</label>
                        <input type="text" id="create-name" name="player_name" 
                               placeholder="Entrez votre nom" maxlength="20" required
                               autocomplete="off">
                    </div>
                    
                    <button type="submit" class="btn btn-primary">
                        Créer une partie
                    </button>
                </form>
            </div>
            
            <!-- Formulaire pour rejoindre -->
            <div class="form-panel" id="join-panel">
                <form method="POST">
                    <input type="hidden" name="action" value="join">
                    
                    <div class="form-group">
                        <label for="join-name">Votre nom</label>
                        <input type="text" id="join-name" name="player_name" 
                               placeholder="Entrez votre nom" maxlength="20" required
                               autocomplete="off">
                    </div>
                    
                    <div class="form-group">
                        <label for="game-code">Code de la partie</label>
                        <input type="text" id="game-code" name="game_code" 
                               placeholder="Ex: ABCD" maxlength="4" required
                               style="text-transform: uppercase; text-align: center; font-size: 1.5rem; letter-spacing: 5px;"
                               autocomplete="off">
                    </div>
                    
                    <button type="submit" class="btn btn-primary">
                        Rejoindre la partie
                    </button>
                </form>
            </div>
        </div>
        
        <div class="roles-info">
            <h3>Les rôles</h3>
            
            <div class="role role-civilian">
                <div class="role-icon">👥</div>
                <div class="role-text">
                    <h4>Civil</h4>
                    <p>Trouve et élimine les infiltrés</p>
                </div>
            </div>
            
            <div class="role role-undercover">
                <div class="role-icon">🕵️</div>
                <div class="role-text">
                    <h4>Undercover</h4>
                    <p>Cache-toi et survis jusqu'à la fin</p>
                </div>
            </div>
            
            <div class="role role-mrwhite">
                <div class="role-icon">👻</div>
                <div class="role-text">
                    <h4>Mr. White</h4>
                    <p>Devine le mot des civils pour gagner</p>
                </div>
            </div>
        </div>
    </div>
    
    <script>
        function showTab(tab) {
            document.querySelectorAll('.tab').forEach(t => t.classList.remove('active'));
            document.querySelectorAll('.form-panel').forEach(p => p.classList.remove('active'));
            
            document.querySelector(`.tab:${tab === 'create' ? 'first-child' : 'last-child'}`).classList.add('active');
            document.getElementById(tab + '-panel').classList.add('active');
        }
        
        // Empêcher le zoom sur iOS
        document.addEventListener('gesturestart', function(e) {
            e.preventDefault();
        });
    </script>
</body>
</html>
