<?php
require_once __DIR__ . '/config.php';

$playerId = $_SESSION['player_id'] ?? null;
$gameCode = $_SESSION['game_code'] ?? null;

if ($playerId && $gameCode) {
    $game = loadGame($gameCode);
    
    if ($game && isset($game['players'][$playerId])) {
        unset($game['players'][$playerId]);
        
        if ($game['host'] === $playerId && !empty($game['players'])) {
            $game['host'] = array_key_first($game['players']);
        }
        
        if (empty($game['players'])) {
            unlink(getGameFilePath($gameCode));
        } else {
            $game['updatedAt'] = time();
            saveGame($gameCode, $game);
        }
    }
}

unset($_SESSION['player_id'], $_SESSION['game_code'], $_SESSION['player_name']);
header('Location: index.php');
exit;
