<?php
require_once __DIR__ . '/config.php';

$error = '';

// Traitement du formulaire
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    
    if ($_POST['action'] === 'create') {
        $playerName = trim($_POST['player_name'] ?? '');
        
        if (empty($playerName)) {
            $error = 'Veuillez entrer votre nom';
        } elseif (strlen($playerName) > 15) {
            $error = 'Le nom doit faire moins de 15 caractères';
        } else {
            // Générer un code unique
            do {
                $code = generateGameCode();
            } while (file_exists(getGameFilePath($code)));
            
            $playerId = uniqid('p_', true);
            
            $game = [
                'code' => $code,
                'status' => 'waiting', // waiting, ready, countdown, playing, result, finished
                'players' => [
                    $playerId => [
                        'id' => $playerId,
                        'name' => htmlspecialchars($playerName),
                        'score' => 0,
                        'ready' => false,
                        'tapped' => false,
                        'tapTime' => null,
                        'falseStart' => false
                    ]
                ],
                'host' => $playerId,
                'round' => 0,
                'roundStartTime' => null,
                'signalTime' => null,
                'signalDelay' => null,
                'roundWinner' => null,
                'gameWinner' => null,
                'lastRoundResult' => null,
                'createdAt' => time(),
                'updatedAt' => time()
            ];
            
            saveGame($code, $game);
            
            $_SESSION['player_id'] = $playerId;
            $_SESSION['game_code'] = $code;
            $_SESSION['player_name'] = $playerName;
            
            echo "<script>window.location.href = 'game.php';</script>";
            exit;
        }
    }
    
    if ($_POST['action'] === 'join') {
        $playerName = trim($_POST['player_name'] ?? '');
        $code = strtoupper(trim($_POST['game_code'] ?? ''));
        
        if (empty($playerName)) {
            $error = 'Veuillez entrer votre nom';
        } elseif (empty($code)) {
            $error = 'Veuillez entrer le code';
        } else {
            $game = loadGame($code);
            
            if (!$game) {
                $error = 'Partie non trouvée';
            } elseif (count($game['players']) >= 2) {
                $error = 'Partie complète (2 joueurs max)';
            } else {
                $playerId = uniqid('p_', true);
                $game['players'][$playerId] = [
                    'id' => $playerId,
                    'name' => htmlspecialchars($playerName),
                    'score' => 0,
                    'ready' => false,
                    'tapped' => false,
                    'tapTime' => null,
                    'falseStart' => false
                ];
                $game['updatedAt'] = time();
                
                saveGame($code, $game);
                
                $_SESSION['player_id'] = $playerId;
                $_SESSION['game_code'] = $code;
                $_SESSION['player_name'] = $playerName;
                
                echo "<script>window.location.href = 'game.php';</script>";
                exit;
            }
        }
    }
}

// Vérifier si déjà dans une partie
if (isset($_SESSION['game_code']) && isset($_SESSION['player_id'])) {
    $existingGame = loadGame($_SESSION['game_code']);
    if ($existingGame && isset($existingGame['players'][$_SESSION['player_id']])) {
        header('Location: game.php');
        exit;
    } else {
        unset($_SESSION['game_code'], $_SESSION['player_id'], $_SESSION['player_name']);
    }
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>⚡ Reaction Duel</title>
    <style>
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }
        
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: linear-gradient(135deg, #0f0f23 0%, #1a1a3e 50%, #0d0d2b 100%);
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            padding: 20px;
            color: #fff;
        }
        
        .container {
            width: 100%;
            max-width: 400px;
        }
        
        .logo {
            text-align: center;
            margin-bottom: 40px;
        }
        
        .logo h1 {
            font-size: 3rem;
            margin-bottom: 10px;
        }
        
        .logo h1 span {
            background: linear-gradient(45deg, #00f5a0, #00d9f5);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
        
        .logo p {
            color: #888;
            font-size: 1.1rem;
        }
        
        .tabs {
            display: flex;
            margin-bottom: 20px;
            background: rgba(255, 255, 255, 0.05);
            border-radius: 15px;
            padding: 5px;
        }
        
        .tab {
            flex: 1;
            padding: 15px;
            text-align: center;
            border-radius: 12px;
            cursor: pointer;
            transition: all 0.3s;
            font-weight: 600;
            color: #888;
        }
        
        .tab.active {
            background: linear-gradient(45deg, #00f5a0, #00d9f5);
            color: #000;
        }
        
        .form-container {
            background: rgba(255, 255, 255, 0.03);
            border-radius: 20px;
            padding: 30px;
            border: 1px solid rgba(255, 255, 255, 0.1);
        }
        
        .form-panel {
            display: none;
        }
        
        .form-panel.active {
            display: block;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 8px;
            font-weight: 500;
            color: #aaa;
        }
        
        .form-group input {
            width: 100%;
            padding: 15px;
            border: 2px solid rgba(255, 255, 255, 0.1);
            border-radius: 12px;
            background: rgba(255, 255, 255, 0.05);
            color: #fff;
            font-size: 1rem;
            transition: all 0.3s;
        }
        
        .form-group input:focus {
            outline: none;
            border-color: #00f5a0;
        }
        
        .form-group input::placeholder {
            color: #555;
        }
        
        .btn {
            width: 100%;
            padding: 16px;
            border: none;
            border-radius: 12px;
            font-size: 1.1rem;
            font-weight: 700;
            cursor: pointer;
            transition: all 0.3s;
            background: linear-gradient(45deg, #00f5a0, #00d9f5);
            color: #000;
        }
        
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 30px rgba(0, 245, 160, 0.3);
        }
        
        .error {
            background: rgba(255, 50, 50, 0.1);
            border: 1px solid #f55;
            color: #f88;
            padding: 12px;
            border-radius: 10px;
            margin-bottom: 20px;
            text-align: center;
        }
        
        .rules {
            margin-top: 30px;
            padding: 20px;
            background: rgba(255, 255, 255, 0.03);
            border-radius: 15px;
            border: 1px solid rgba(255, 255, 255, 0.05);
        }
        
        .rules h3 {
            color: #00f5a0;
            margin-bottom: 15px;
            text-align: center;
        }
        
        .rule {
            display: flex;
            align-items: flex-start;
            margin-bottom: 12px;
            font-size: 0.9rem;
            color: #aaa;
        }
        
        .rule-icon {
            margin-right: 10px;
            font-size: 1.1rem;
        }

        #game-code {
            text-transform: uppercase;
            text-align: center;
            font-size: 1.5rem;
            letter-spacing: 5px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="logo">
            <h1>⚡ <span>Reaction Duel</span></h1>
            <p>Le plus rapide gagne !</p>
        </div>
        
        <div class="tabs">
            <div class="tab active" onclick="showTab('create')">Créer</div>
            <div class="tab" onclick="showTab('join')">Rejoindre</div>
        </div>
        
        <div class="form-container">
            <?php if ($error): ?>
                <div class="error"><?= htmlspecialchars($error) ?></div>
            <?php endif; ?>
            
            <div class="form-panel active" id="create-panel">
                <form method="POST">
                    <input type="hidden" name="action" value="create">
                    <div class="form-group">
                        <label>Ton pseudo</label>
                        <input type="text" name="player_name" placeholder="Ex: Alex" maxlength="15" required autocomplete="off">
                    </div>
                    <button type="submit" class="btn">⚡ Créer un duel</button>
                </form>
            </div>
            
            <div class="form-panel" id="join-panel">
                <form method="POST">
                    <input type="hidden" name="action" value="join">
                    <div class="form-group">
                        <label>Ton pseudo</label>
                        <input type="text" name="player_name" placeholder="Ex: Max" maxlength="15" required autocomplete="off">
                    </div>
                    <div class="form-group">
                        <label>Code du duel</label>
                        <input type="text" id="game-code" name="game_code" placeholder="XXXX" maxlength="4" required autocomplete="off">
                    </div>
                    <button type="submit" class="btn">🎯 Rejoindre</button>
                </form>
            </div>
        </div>
        
        <div class="rules">
            <h3>📜 Règles</h3>
            <div class="rule">
                <span class="rule-icon">🔴</span>
                <span>Attends que l'écran devienne <strong style="color: #00f5a0;">VERT</strong></span>
            </div>
            <div class="rule">
                <span class="rule-icon">👆</span>
                <span>Tape le plus vite possible quand c'est vert !</span>
            </div>
            <div class="rule">
                <span class="rule-icon">⚠️</span>
                <span>Faux départ = tu perds le round</span>
            </div>
            <div class="rule">
                <span class="rule-icon">🏆</span>
                <span>Premier à <strong>5 points</strong> gagne</span>
            </div>
        </div>
    </div>
    
    <script>
        function showTab(tab) {
            document.querySelectorAll('.tab').forEach(t => t.classList.remove('active'));
            document.querySelectorAll('.form-panel').forEach(p => p.classList.remove('active'));
            event.target.classList.add('active');
            document.getElementById(tab + '-panel').classList.add('active');
        }
    </script>
</body>
</html>
