<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>3CX Update Manager</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
            background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
            min-height: 100vh;
            padding: 20px;
        }

        .container {
            max-width: 1400px;
            margin: 0 auto;
        }

        .header {
            background: white;
            border-radius: 15px;
            padding: 30px;
            margin-bottom: 30px;
            box-shadow: 0 10px 30px rgba(28, 109, 158, 0.1);
        }

        h1 {
            color: #1c6d9e;
            font-size: 32px;
            margin-bottom: 10px;
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .subtitle {
            color: #6c757d;
            font-size: 14px;
        }

        .upload-section {
            background: white;
            border-radius: 15px;
            padding: 30px;
            margin-bottom: 30px;
            box-shadow: 0 10px 30px rgba(28, 109, 158, 0.1);
        }

        .file-upload-area {
            border: 2px dashed #1c6d9e;
            border-radius: 10px;
            padding: 40px;
            text-align: center;
            transition: all 0.3s;
            cursor: pointer;
            background: #f8f9fa;
        }

        .file-upload-area:hover {
            background: #e8f4f8;
            border-color: #145577;
        }

        .file-upload-area.dragover {
            background: #e8f4f8;
            border-color: #145577;
            transform: scale(1.02);
        }

        .file-info {
            margin-top: 20px;
            padding: 15px;
            background: #e8f4f8;
            border-radius: 8px;
            display: none;
        }

        .file-info.active {
            display: block;
        }

        .btn {
            padding: 12px 24px;
            border: none;
            border-radius: 8px;
            font-size: 16px;
            cursor: pointer;
            transition: all 0.3s;
            font-weight: 500;
        }

        .btn-primary {
            background: #1c6d9e;
            color: white;
        }

        .btn-primary:hover {
            background: #145577;
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(28, 109, 158, 0.3);
        }

        .btn-primary:disabled {
            background: #95a5a6;
            cursor: not-allowed;
            transform: none;
        }

        .btn-success {
            background: #28a745;
            color: white;
        }

        .btn-success:hover {
            background: #218838;
        }

        .btn-success:disabled {
            background: #95a5a6;
            cursor: not-allowed;
        }

        .btn-warning {
            background: #ffc107;
            color: #212529;
        }

        .btn-warning:hover {
            background: #e0a800;
        }

        .btn-info {
            background: #17a2b8;
            color: white;
        }

        .btn-info:hover {
            background: #138496;
        }

        .btn-danger {
            background: #dc3545;
            color: white;
        }

        .btn-danger:hover {
            background: #c82333;
        }

        .btn-sm {
            padding: 8px 16px;
            font-size: 14px;
        }

        .servers-section {
            background: white;
            border-radius: 15px;
            padding: 30px;
            box-shadow: 0 10px 30px rgba(28, 109, 158, 0.1);
        }

        .section-title {
            color: #1c6d9e;
            font-size: 24px;
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .search-container {
            margin-bottom: 20px;
        }

        .search-wrapper {
            position: relative;
            display: flex;
            align-items: center;
            background: white;
            border: 2px solid #e9ecef;
            border-radius: 10px;
            padding: 0;
            transition: all 0.3s;
        }

        .search-wrapper:focus-within {
            border-color: #1c6d9e;
            box-shadow: 0 0 0 3px rgba(28, 109, 158, 0.1);
        }

        .search-icon {
            width: 24px;
            height: 24px;
            margin: 12px;
            flex-shrink: 0;
        }

        #searchInput {
            flex: 1;
            border: none;
            outline: none;
            padding: 12px 0;
            font-size: 16px;
            background: transparent;
        }

        .clear-search {
            background: none;
            border: none;
            padding: 12px;
            cursor: pointer;
            display: flex;
            align-items: center;
            transition: opacity 0.3s;
        }

        .clear-search:hover {
            opacity: 0.7;
        }

        .search-results {
            margin-top: 10px;
            padding: 10px 15px;
            background: #f8f9fa;
            border-radius: 8px;
            font-size: 14px;
            color: #6c757d;
        }

        .filter-tabs {
            display: flex;
            gap: 10px;
            margin-bottom: 20px;
            background: #f8f9fa;
            padding: 15px;
            border-radius: 10px;
            flex-wrap: wrap;
        }

        .filter-tab {
            padding: 10px 20px;
            background: white;
            border: 2px solid #e9ecef;
            border-radius: 8px;
            color: #495057;
            cursor: pointer;
            transition: all 0.3s;
            font-size: 14px;
            font-weight: 500;
            display: flex;
            align-items: center;
            gap: 5px;
        }

        .filter-tab:hover {
            background: #f8f9fa;
            border-color: #1c6d9e;
            transform: translateY(-2px);
        }

        .filter-tab.active {
            background: #1c6d9e;
            color: white;
            border-color: #1c6d9e;
        }

        .filter-tab span {
            font-weight: bold;
        }

        .bulk-actions {
            background: #f8f9fa;
            padding: 20px;
            border-radius: 10px;
            margin-bottom: 20px;
            display: flex;
            gap: 15px;
            align-items: center;
            flex-wrap: wrap;
        }

        .selection-info {
            color: #1c6d9e;
            font-weight: 500;
            margin-right: auto;
        }

        .table-container {
            overflow-x: auto;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        th {
            background: #1c6d9e;
            color: white;
            padding: 15px;
            text-align: left;
            font-weight: 500;
            position: sticky;
            top: 0;
            z-index: 10;
        }

        td {
            padding: 15px;
            border-bottom: 1px solid #e9ecef;
        }

        tbody tr:hover {
            background: #f8f9fa;
        }

        tbody tr.selected {
            background: #e8f4f8;
        }

        tbody tr.hidden {
            display: none;
        }

        tbody tr.search-hidden {
            display: none !important;
        }

        .highlight {
            background-color: #fff3cd;
            font-weight: 500;
            padding: 2px 4px;
            border-radius: 3px;
        }

        .checkbox-cell {
            width: 50px;
        }

        input[type="checkbox"] {
            width: 18px;
            height: 18px;
            cursor: pointer;
        }

        .status-badge {
            display: inline-block;
            padding: 5px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 500;
        }

        .status-checking {
            background: #e3f2fd;
            color: #1976d2;
        }

        .status-updated {
            background: #e8f5e9;
            color: #2e7d32;
        }

        .status-available {
            background: #fff3e0;
            color: #f57c00;
        }

        .status-error {
            background: #ffebee;
            color: #c62828;
        }

        .status-updating {
            background: #f3e5f5;
            color: #7b1fa2;
            animation: pulse 2s infinite;
        }

        @keyframes pulse {
            0%, 100% { opacity: 1; }
            50% { opacity: 0.7; }
        }

        .loading-spinner {
            display: inline-block;
            width: 20px;
            height: 20px;
            border: 3px solid #f3f3f3;
            border-top: 3px solid #1c6d9e;
            border-radius: 50%;
            animation: spin 1s linear infinite;
            margin-right: 10px;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        .icon {
            width: 24px;
            height: 24px;
            vertical-align: middle;
        }

        .alert {
            padding: 15px 20px;
            border-radius: 8px;
            margin-bottom: 20px;
        }

        .alert-info {
            background: #e3f2fd;
            color: #1976d2;
            border-left: 4px solid #1976d2;
        }

        .alert-success {
            background: #e8f5e9;
            color: #2e7d32;
            border-left: 4px solid #2e7d32;
        }

        .alert-warning {
            background: #fff3e0;
            color: #f57c00;
            border-left: 4px solid #f57c00;
        }

        .alert-error {
            background: #ffebee;
            color: #c62828;
            border-left: 4px solid #c62828;
        }

        .modal {
            display: none;
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            animation: fadeIn 0.3s;
        }

        .modal.active {
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .modal-content {
            background: white;
            padding: 30px;
            border-radius: 15px;
            max-width: 600px;
            width: 90%;
            max-height: 80vh;
            overflow-y: auto;
            animation: slideIn 0.3s;
        }

        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }

        @keyframes slideIn {
            from { 
                opacity: 0;
                transform: translateY(-30px);
            }
            to { 
                opacity: 1;
                transform: translateY(0);
            }
        }

        .modal-header {
            margin-bottom: 20px;
        }

        .modal-title {
            color: #1c6d9e;
            font-size: 24px;
        }

        .modal-body {
            margin-bottom: 20px;
            color: #495057;
        }

        .modal-footer {
            display: flex;
            gap: 10px;
            justify-content: flex-end;
        }

        .progress-container {
            margin-top: 20px;
        }

        .progress-bar {
            width: 100%;
            height: 8px;
            background: #e9ecef;
            border-radius: 4px;
            overflow: hidden;
            margin-top: 10px;
        }

        .progress-fill {
            height: 100%;
            background: #1c6d9e;
            transition: width 0.3s;
        }

        .progress-text {
            margin-top: 10px;
            color: #6c757d;
            font-size: 14px;
        }

        .server-list {
            max-height: 300px;
            overflow-y: auto;
            border: 1px solid #e9ecef;
            border-radius: 5px;
            padding: 10px;
            margin-top: 10px;
        }

        .server-list-item {
            padding: 8px;
            border-bottom: 1px solid #f0f0f0;
        }

        .server-list-item:last-child {
            border-bottom: none;
        }

        .tooltip {
            position: relative;
            display: inline-block;
        }

        .tooltip .tooltiptext {
            visibility: hidden;
            width: 200px;
            background-color: #333;
            color: #fff;
            text-align: center;
            border-radius: 6px;
            padding: 8px;
            position: absolute;
            z-index: 1;
            bottom: 125%;
            left: 50%;
            margin-left: -100px;
            opacity: 0;
            transition: opacity 0.3s;
            font-size: 12px;
        }

        .tooltip:hover .tooltiptext {
            visibility: visible;
            opacity: 1;
        }

        /* Dashboard Styles */
        .dashboard-container {
            background: white;
            border-radius: 15px;
            padding: 30px;
            margin-bottom: 30px;
            box-shadow: 0 10px 30px rgba(28, 109, 158, 0.1);
            display: none;
        }

        .dashboard-container.active {
            display: block;
        }

        .dashboard-title {
            color: #1c6d9e;
            font-size: 24px;
            margin-bottom: 25px;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }

        .stat-card {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 12px;
            padding: 20px;
            color: white;
            position: relative;
            overflow: hidden;
        }

        .stat-card.success {
            background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%);
        }

        .stat-card.warning {
            background: linear-gradient(135deg, #f2994a 0%, #f2c94c 100%);
        }

        .stat-card.danger {
            background: linear-gradient(135deg, #eb3349 0%, #f45c43 100%);
        }

        .stat-card.info {
            background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
        }

        .stat-value {
            font-size: 36px;
            font-weight: bold;
            margin-bottom: 5px;
        }

        .stat-label {
            font-size: 14px;
            opacity: 0.9;
        }

        .stat-icon {
            position: absolute;
            right: 15px;
            top: 50%;
            transform: translateY(-50%);
            opacity: 0.3;
            width: 60px;
            height: 60px;
        }

        .chart-container {
            background: #f8f9fa;
            border-radius: 12px;
            padding: 20px;
            margin-bottom: 20px;
        }

        .chart-title {
            font-size: 18px;
            color: #2c3e50;
            margin-bottom: 15px;
        }

        /* Guide Modal */
        .guide-content {
            max-height: 500px;
            overflow-y: auto;
        }

        .guide-section {
            margin-bottom: 25px;
        }

        .guide-section h4 {
            color: #1c6d9e;
            margin-bottom: 10px;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .guide-section p {
            color: #495057;
            line-height: 1.6;
        }

        .guide-section code {
            background: #f4f4f4;
            padding: 2px 6px;
            border-radius: 3px;
            color: #e83e8c;
            font-family: monospace;
        }

        .guide-section pre {
            background: #2c3e50;
            color: #fff;
            padding: 15px;
            border-radius: 8px;
            overflow-x: auto;
            margin: 10px 0;
        }

        .guide-tip {
            background: #e8f4f8;
            border-left: 4px solid #1c6d9e;
            padding: 12px;
            margin: 10px 0;
            border-radius: 4px;
        }

        .guide-warning {
            background: #fff3cd;
            border-left: 4px solid #ffc107;
            padding: 12px;
            margin: 10px 0;
            border-radius: 4px;
        }
        .services-modal {
            max-width: 900px;
        }

        .services-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            padding-bottom: 15px;
            border-bottom: 2px solid #e9ecef;
        }

        .services-grid {
            display: grid;
            gap: 15px;
            max-height: 500px;
            overflow-y: auto;
            padding-right: 10px;
        }

        .service-card {
            background: #f8f9fa;
            border-radius: 10px;
            padding: 15px;
            border: 2px solid #e9ecef;
            transition: all 0.3s;
        }

        .service-card:hover {
            border-color: #1c6d9e;
            box-shadow: 0 5px 15px rgba(28, 109, 158, 0.1);
        }

        .service-header {
            display: flex;
            justify-content: space-between;
            align-items: start;
            margin-bottom: 10px;
        }

        .service-name {
            font-weight: 600;
            color: #2c3e50;
            font-size: 14px;
            word-break: break-word;
        }

        .service-display-name {
            color: #6c757d;
            font-size: 12px;
            margin-top: 2px;
        }

        .service-status {
            display: inline-flex;
            align-items: center;
            gap: 5px;
            padding: 4px 10px;
            border-radius: 15px;
            font-size: 12px;
            font-weight: 500;
        }

        .service-status.running {
            background: #d4edda;
            color: #155724;
        }

        .service-status.stopped {
            background: #f8d7da;
            color: #721c24;
        }

        .service-status.starting {
            background: #fff3cd;
            color: #856404;
        }

        .service-info {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(120px, 1fr));
            gap: 10px;
            margin-top: 10px;
            padding-top: 10px;
            border-top: 1px solid #dee2e6;
        }

        .service-metric {
            display: flex;
            flex-direction: column;
        }

        .service-metric-label {
            font-size: 11px;
            color: #6c757d;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .service-metric-value {
            font-size: 14px;
            font-weight: 600;
            color: #2c3e50;
        }

        .service-actions {
            margin-top: 10px;
            display: flex;
            gap: 10px;
        }

        .btn-restart {
            background: #ffc107;
            color: #212529;
            padding: 6px 12px;
            border: none;
            border-radius: 5px;
            font-size: 12px;
            cursor: pointer;
            display: flex;
            align-items: center;
            gap: 5px;
            transition: all 0.3s;
        }

        .btn-restart:hover {
            background: #e0a800;
        }

        .btn-restart:disabled {
            background: #e9ecef;
            color: #6c757d;
            cursor: not-allowed;
        }

        .services-loading {
            text-align: center;
            padding: 50px;
        }

        .services-error {
            text-align: center;
            padding: 30px;
            color: #dc3545;
        }

        .status-dot {
            width: 8px;
            height: 8px;
            border-radius: 50%;
            display: inline-block;
        }

        .status-dot.running {
            background: #28a745;
            animation: pulse-green 2s infinite;
        }

        .status-dot.stopped {
            background: #dc3545;
        }

        @keyframes pulse-green {
            0%, 100% {
                box-shadow: 0 0 0 0 rgba(40, 167, 69, 0.4);
            }
            50% {
                box-shadow: 0 0 0 10px rgba(40, 167, 69, 0);
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Header -->
        <div class="header">
            <h1>
                <svg class="icon" style="width: 40px; height: 40px;" fill="#1c6d9e" viewBox="0 0 24 24">
                    <path d="M12,2A10,10 0 0,0 2,12A10,10 0 0,0 12,22A10,10 0 0,0 22,12A10,10 0 0,0 12,2M12,4A8,8 0 0,1 20,12A8,8 0 0,1 12,20A8,8 0 0,1 4,12A8,8 0 0,1 12,4M11,7V13L16.25,15.85L17.25,14.15L13,11.85V7H11Z"/>
                </svg>
                3CX Update Manager
            </h1>
            <p class="subtitle">Gestionnaire centralisé des mises à jour pour vos serveurs 3CX</p>
        </div>

        <!-- Upload Section -->
        <div class="upload-section">
            <h2 class="section-title">Configuration</h2>
            
            <div id="dropZone" class="file-upload-area">
                <svg class="icon" style="width: 48px; height: 48px; margin-bottom: 15px;" fill="#1c6d9e" viewBox="0 0 24 24">
                    <path d="M14,2H6A2,2 0 0,0 4,4V20A2,2 0 0,0 6,22H18A2,2 0 0,0 20,20V8L14,2M18,20H6V4H13V9H18V20M12,12L8,16H10.5V19H13.5V16H16L12,12Z"/>
                </svg>
                <p style="color: #1c6d9e; font-size: 18px; margin-bottom: 10px;">Glissez-déposez votre fichier CSV ici</p>
                <p style="color: #6c757d; margin-bottom: 15px;">ou</p>
                <input type="file" id="csvFile" accept=".csv" style="display: none;">
                <button class="btn btn-primary" onclick="document.getElementById('csvFile').click()">
                    Parcourir
                </button>
            </div>

            <div id="fileInfo" class="file-info">
                <strong>Fichier chargé :</strong> <span id="fileName"></span>
                <button class="btn btn-danger btn-sm" style="float: right;" onclick="clearFile()">Supprimer</button>
            </div>

            <div style="margin-top: 20px; display: flex; gap: 10px; flex-wrap: wrap;">
                <button id="loadServersBtn" class="btn btn-primary" onclick="loadServers()" disabled>
                    <svg class="icon" fill="white" viewBox="0 0 24 24" style="width: 20px; height: 20px; vertical-align: middle; margin-right: 5px;">
                        <path d="M12,18.17L8.83,15L7.42,16.41L12,21L16.59,16.41L15.17,15M12,5.83L15.17,9L16.58,7.59L12,3L7.41,7.59L8.83,9L12,5.83Z"/>
                    </svg>
                    Charger les serveurs
                </button>
                <button class="btn btn-success" onclick="downloadTemplate()">
                    <svg class="icon" fill="white" viewBox="0 0 24 24" style="width: 20px; height: 20px; vertical-align: middle; margin-right: 5px;">
                        <path d="M14,2H6A2,2 0 0,0 4,4V20A2,2 0 0,0 6,22H18A2,2 0 0,0 20,20V8L14,2M18,20H6V4H13V9H18V20M12,19L8,15H10.5V12H13.5V15H16L12,19Z"/>
                    </svg>
                    Télécharger Template CSV
                </button>
                <button class="btn btn-info" onclick="showGuide()">
                    <svg class="icon" fill="white" viewBox="0 0 24 24" style="width: 20px; height: 20px; vertical-align: middle; margin-right: 5px;">
                        <path d="M11,18H13V16H11V18M12,2A10,10 0 0,0 2,12A10,10 0 0,0 12,22A10,10 0 0,0 22,12A10,10 0 0,0 12,2M12,20C7.59,20 4,16.41 4,12C4,7.59 7.59,4 12,4C16.41,4 20,7.59 20,12C20,16.41 16.41,20 12,20M12,6A4,4 0 0,0 8,10H10A2,2 0 0,1 12,8A2,2 0 0,1 14,10C14,12 11,11.75 11,15H13C13,12.75 16,12.5 16,10A4,4 0 0,0 12,6Z"/>
                    </svg>
                    Guide d'utilisation
                </button>
                <button class="btn btn-warning" onclick="toggleDashboard()" style="display: none;" id="dashboardBtn">
                    <svg class="icon" fill="black" viewBox="0 0 24 24" style="width: 20px; height: 20px; vertical-align: middle; margin-right: 5px;">
                        <path d="M19,3H5C3.89,3 3,3.89 3,5V19A2,2 0 0,0 5,21H19A2,2 0 0,0 21,19V5C21,3.89 20.1,3 19,3M9,17H7V10H9V17M13,17H11V7H13V17M17,17H15V13H17V17Z"/>
                    </svg>
                    Dashboard
                </button>
            </div>
        </div>

        <!-- Dashboard -->
        <div class="dashboard-container" id="dashboardContainer">
            <h2 class="dashboard-title">
                <svg class="icon" fill="#1c6d9e" viewBox="0 0 24 24" style="width: 30px; height: 30px;">
                    <path d="M19,3H5C3.89,3 3,3.89 3,5V19A2,2 0 0,0 5,21H19A2,2 0 0,0 21,19V5C21,3.89 20.1,3 19,3M9,17H7V10H9V17M13,17H11V7H13V17M17,17H15V13H17V17Z"/>
                </svg>
                Tableau de bord
            </h2>
            
            <div class="stats-grid">
                <div class="stat-card">
                    <div class="stat-value" id="statTotal">0</div>
                    <div class="stat-label">Total serveurs</div>
                    <svg class="stat-icon" fill="white" viewBox="0 0 24 24">
                        <path d="M4,1H20A1,1 0 0,1 21,2V6A1,1 0 0,1 20,7H4A1,1 0 0,1 3,6V2A1,1 0 0,1 4,1M4,9H20A1,1 0 0,1 21,10V14A1,1 0 0,1 20,15H4A1,1 0 0,1 3,14V10A1,1 0 0,1 4,9M4,17H20A1,1 0 0,1 21,18V22A1,1 0 0,1 20,23H4A1,1 0 0,1 3,22V18A1,1 0 0,1 4,17M9,5H10V3H9V5M9,13H10V11H9V13M9,21H10V19H9V21M5,5H7V3H5V5M5,13H7V11H5V13M5,21H7V19H5V21Z"/>
                    </svg>
                </div>
                <div class="stat-card success">
                    <div class="stat-value" id="statUpdated">0</div>
                    <div class="stat-label">À jour</div>
                    <svg class="stat-icon" fill="white" viewBox="0 0 24 24">
                        <path d="M21,7L9,19L3.5,13.5L4.91,12.09L9,16.17L19.59,5.59L21,7Z"/>
                    </svg>
                </div>
                <div class="stat-card warning">
                    <div class="stat-value" id="statAvailable">0</div>
                    <div class="stat-label">Mises à jour disponibles</div>
                    <svg class="stat-icon" fill="white" viewBox="0 0 24 24">
                        <path d="M12,18.17L8.83,15L7.42,16.41L12,21L16.59,16.41L15.17,15M12,5.83L15.17,9L16.58,7.59L12,3L7.41,7.59L8.83,9L12,5.83Z"/>
                    </svg>
                </div>
                <div class="stat-card danger">
                    <div class="stat-value" id="statError">0</div>
                    <div class="stat-label">Erreurs</div>
                    <svg class="stat-icon" fill="white" viewBox="0 0 24 24">
                        <path d="M13,13H11V7H13M13,17H11V15H13M12,2A10,10 0 0,0 2,12A10,10 0 0,0 12,22A10,10 0 0,0 22,12A10,10 0 0,0 12,2Z"/>
                    </svg>
                </div>
                <div class="stat-card info">
                    <div class="stat-value" id="statPending">0</div>
                    <div class="stat-label">Non vérifiés</div>
                    <svg class="stat-icon" fill="white" viewBox="0 0 24 24">
                        <path d="M12,20A8,8 0 0,0 20,12A8,8 0 0,0 12,4A8,8 0 0,0 4,12A8,8 0 0,0 12,20M12,2A10,10 0 0,1 22,12A10,10 0 0,1 12,22C6.47,22 2,17.5 2,12A10,10 0 0,1 12,2M12.5,7V12.25L17,14.92L16.25,16.15L11,13V7H12.5Z"/>
                    </svg>
                </div>
            </div>
            
            <div class="chart-container">
                <div class="chart-title">Répartition des statuts</div>
                <div style="position: relative; height: 300px;">
                    <canvas id="statusChart"></canvas>
                </div>
            </div>
            
            <div class="chart-container">
                <div class="chart-title">Progression des vérifications</div>
                <div style="position: relative; height: 100px;">
                    <canvas id="progressChart"></canvas>
                </div>
            </div>
        </div>

        <!-- Servers Section -->
        <div class="servers-section" id="serversSection" style="display: none;">
            <h2 class="section-title">
                <span>Serveurs 3CX</span>
                <span id="serverCount" class="status-badge status-checking"></span>
            </h2>
            
            <div id="alertContainer"></div>

            <!-- Search Bar -->
            <div class="search-container">
                <div class="search-wrapper">
                    <svg class="search-icon" fill="#1c6d9e" viewBox="0 0 24 24">
                        <path d="M9.5,3A6.5,6.5 0 0,1 16,9.5C16,11.11 15.41,12.59 14.44,13.73L14.71,14H15.5L20.5,19L19,20.5L14,15.5V14.71L13.73,14.44C12.59,15.41 11.11,16 9.5,16A6.5,6.5 0 0,1 3,9.5A6.5,6.5 0 0,1 9.5,3M9.5,5C7,5 5,7 5,9.5C5,12 7,14 9.5,14C12,14 14,12 14,9.5C14,7 12,5 9.5,5Z"/>
                    </svg>
                    <input type="text" id="searchInput" placeholder="Rechercher dans le tableau..." onkeyup="searchTable()">
                    <button class="clear-search" id="clearSearchBtn" onclick="clearSearch()" style="display: none;">
                        <svg fill="#6c757d" viewBox="0 0 24 24" style="width: 18px; height: 18px;">
                            <path d="M19,6.41L17.59,5L12,10.59L6.41,5L5,6.41L10.59,12L5,17.59L6.41,19L12,13.41L17.59,19L19,17.59L13.41,12L19,6.41Z"/>
                        </svg>
                    </button>
                </div>
                <div class="search-results" id="searchResults" style="display: none;">
                    <span id="searchResultsText">0 résultat(s) trouvé(s)</span>
                </div>
            </div>

            <!-- Filter Tabs -->
            <div class="filter-tabs">
                <button class="filter-tab active" onclick="filterServers('all')" id="tab-all">
                    <svg class="icon" fill="currentColor" viewBox="0 0 24 24" style="width: 16px; height: 16px; vertical-align: middle; margin-right: 5px;">
                        <path d="M3,5H9V11H3V5M5,7V9H7V7H5M11,7H21V9H11V7M11,15H21V17H11V15M5,20L1.5,16.5L2.91,15.09L5,17.17L9.59,12.59L11,14L5,20Z"/>
                    </svg>
                    Tous (<span id="count-all">0</span>)
                </button>
                <button class="filter-tab" onclick="filterServers('updates')" id="tab-updates">
                    <svg class="icon" fill="currentColor" viewBox="0 0 24 24" style="width: 16px; height: 16px; vertical-align: middle; margin-right: 5px;">
                        <path d="M12,18.17L8.83,15L7.42,16.41L12,21L16.59,16.41L15.17,15M12,5.83L15.17,9L16.58,7.59L12,3L7.41,7.59L8.83,9L12,5.83Z"/>
                    </svg>
                    Mises à jour disponibles (<span id="count-updates">0</span>)
                </button>
                <button class="filter-tab" onclick="filterServers('updated')" id="tab-updated">
                    <svg class="icon" fill="currentColor" viewBox="0 0 24 24" style="width: 16px; height: 16px; vertical-align: middle; margin-right: 5px;">
                        <path d="M21,7L9,19L3.5,13.5L4.91,12.09L9,16.17L19.59,5.59L21,7Z"/>
                    </svg>
                    À jour (<span id="count-updated">0</span>)
                </button>
                <button class="filter-tab" onclick="filterServers('error')" id="tab-error">
                    <svg class="icon" fill="currentColor" viewBox="0 0 24 24" style="width: 16px; height: 16px; vertical-align: middle; margin-right: 5px;">
                        <path d="M13,13H11V7H13M13,17H11V15H13M12,2A10,10 0 0,0 2,12A10,10 0 0,0 12,22A10,10 0 0,0 22,12A10,10 0 0,0 12,2Z"/>
                    </svg>
                    Erreurs (<span id="count-error">0</span>)
                </button>
                <button class="filter-tab" onclick="filterServers('pending')" id="tab-pending">
                    <svg class="icon" fill="currentColor" viewBox="0 0 24 24" style="width: 16px; height: 16px; vertical-align: middle; margin-right: 5px;">
                        <path d="M12,20A8,8 0 0,0 20,12A8,8 0 0,0 12,4A8,8 0 0,0 4,12A8,8 0 0,0 12,20M12,2A10,10 0 0,1 22,12A10,10 0 0,1 12,22C6.47,22 2,17.5 2,12A10,10 0 0,1 12,2M12.5,7V12.25L17,14.92L16.25,16.15L11,13V7H12.5Z"/>
                    </svg>
                    En attente (<span id="count-pending">0</span>)
                </button>
            </div>

            <!-- Bulk Actions -->
            <div class="bulk-actions">
                <div class="selection-info">
                    <span id="selectedCount">0</span> serveur(s) sélectionné(s)
                    <span id="lastCheckInfo" style="margin-left: 15px; color: #6c757d; font-size: 12px;"></span>
                </div>
                <button class="btn btn-primary btn-sm" onclick="selectAllVisible()">
                    Sélectionner visibles
                </button>
                <button class="btn btn-warning btn-sm" onclick="deselectAll()">
                    Tout désélectionner
                </button>
                <button id="bulkCheckBtn" class="btn btn-primary btn-sm" onclick="checkSelectedServers()" disabled>
                    <svg class="icon" fill="white" viewBox="0 0 24 24" style="width: 16px; height: 16px; vertical-align: middle; margin-right: 5px;">
                        <path d="M17.65,6.35C16.2,4.9 14.21,4 12,4A8,8 0 0,0 4,12A8,8 0 0,0 12,20C15.73,20 18.84,17.45 19.73,14H17.65C16.83,16.33 14.61,18 12,18A6,6 0 0,1 6,12A6,6 0 0,1 12,6C13.66,6 15.14,6.69 16.22,7.78L13,11H20V4L17.65,6.35Z"/>
                    </svg>
                    Vérifier la sélection
                </button>
                <button id="bulkUpdateBtn" class="btn btn-success btn-sm" onclick="updateSelectedServers()" disabled>
                    <svg class="icon" fill="white" viewBox="0 0 24 24" style="width: 16px; height: 16px; vertical-align: middle; margin-right: 5px;">
                        <path d="M12,18.17L8.83,15L7.42,16.41L12,21L16.59,16.41L15.17,15M12,5.83L15.17,9L16.58,7.59L12,3L7.41,7.59L8.83,9L12,5.83Z"/>
                    </svg>
                    Mettre à jour la sélection
                </button>
                <button class="btn btn-danger btn-sm" onclick="clearSavedState()" title="Effacer les données sauvegardées">
                    <svg class="icon" fill="white" viewBox="0 0 24 24" style="width: 16px; height: 16px;">
                        <path d="M19,4H15.5L14.5,3H9.5L8.5,4H5V6H19M6,19A2,2 0 0,0 8,21H16A2,2 0 0,0 18,19V7H6V19Z"/>
                    </svg>
                </button>
                <div style="margin-left: auto; display: flex; align-items: center; gap: 10px;">
                    <label style="font-size: 14px; color: #6c757d;">Traiter par lots de :</label>
                    <select id="batchSize" style="padding: 5px 10px; border-radius: 5px; border: 1px solid #dee2e6;">
                        <option value="5">5 serveurs</option>
                        <option value="10" selected>10 serveurs</option>
                        <option value="15">15 serveurs</option>
                        <option value="20">20 serveurs</option>
                        <option value="30">30 serveurs</option>
                        <option value="50">50 serveurs</option>
                    </select>
                </div>
            </div>

            <div class="table-container">
                <table>
                    <thead>
                        <tr>
                            <th class="checkbox-cell">
                                <input type="checkbox" id="selectAllCheckbox" onchange="toggleSelectAll()">
                            </th>
                            <th>#</th>
                            <th>URL du serveur</th>
                            <th>Identifiant</th>
                            <th>Version actuelle</th>
                            <th>Nouvelle version</th>
                            <th>Statut</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody id="serversTableBody">
                        <!-- Les serveurs seront ajoutés ici -->
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Modal de confirmation pour mise à jour unique -->
    <div id="confirmModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title">Confirmer la mise à jour</h3>
            </div>
            <div class="modal-body" id="modalBody">
                <!-- Le contenu sera injecté ici -->
            </div>
            <div class="modal-footer">
                <button class="btn btn-danger" onclick="closeModal()">Annuler</button>
                <button class="btn btn-success" onclick="confirmUpdate()">Confirmer</button>
            </div>
        </div>
    </div>

    <!-- Modal pour les actions groupées -->
    <div id="bulkModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title" id="bulkModalTitle">Action groupée</h3>
            </div>
            <div class="modal-body">
                <div id="bulkModalBody">
                    <!-- Le contenu sera injecté ici -->
                </div>
                <div class="progress-container" id="progressContainer" style="display: none;">
                    <div class="progress-bar">
                        <div class="progress-fill" id="progressFill" style="width: 0%"></div>
                    </div>
                    <div class="progress-text" id="progressText">0 / 0</div>
                </div>
            </div>
            <div class="modal-footer" id="bulkModalFooter">
                <button class="btn btn-danger" onclick="closeBulkModal()">Annuler</button>
                <button class="btn btn-success" id="bulkConfirmBtn" onclick="confirmBulkAction()">Confirmer</button>
            </div>
        </div>
    </div>

    <!-- Modal pour les services -->
    <div id="servicesModal" class="modal">
        <div class="modal-content services-modal">
            <div class="modal-header">
                <h3 class="modal-title">Services 3CX</h3>
            </div>
            <div class="modal-body">
                <div class="services-header">
                    <div>
                        <strong>Serveur :</strong> <span id="servicesServerUrl"></span>
                    </div>
                    <button class="btn btn-primary btn-sm" onclick="refreshServices()">
                        <svg fill="white" viewBox="0 0 24 24" style="width: 16px; height: 16px; vertical-align: middle; margin-right: 5px;">
                            <path d="M17.65,6.35C16.2,4.9 14.21,4 12,4A8,8 0 0,0 4,12A8,8 0 0,0 12,20C15.73,20 18.84,17.45 19.73,14H17.65C16.83,16.33 14.61,18 12,18A6,6 0 0,1 6,12A6,6 0 0,1 12,6C13.66,6 15.14,6.69 16.22,7.78L13,11H20V4L17.65,6.35Z"/>
                        </svg>
                        Actualiser
                    </button>
                </div>
                <div id="servicesContent">
                    <!-- Le contenu sera injecté ici -->
                </div>
            </div>
            <div class="modal-footer">
                <button class="btn btn-danger" onclick="closeServicesModal()">Fermer</button>
            </div>
        </div>
    </div>

    <!-- Modal Guide -->
    <div id="guideModal" class="modal">
        <div class="modal-content" style="max-width: 800px;">
            <div class="modal-header">
                <h3 class="modal-title">📚 Guide d'utilisation - 3CX Update Manager</h3>
            </div>
            <div class="modal-body guide-content">
                <div class="guide-section">
                    <h4>
                        <svg fill="#1c6d9e" viewBox="0 0 24 24" style="width: 20px; height: 20px;">
                            <path d="M14,2H6A2,2 0 0,0 4,4V20A2,2 0 0,0 6,22H18A2,2 0 0,0 20,20V8L14,2M18,20H6V4H13V9H18V20Z"/>
                        </svg>
                        Format du fichier CSV
                    </h4>
                    <p>Le fichier CSV doit contenir <strong>exactement</strong> ces colonnes (sensible à la casse) :</p>
                    <pre>URL Web 3CX,Identifiant 3CX,Mot de passe 3CX</pre>
                    
                    <div class="guide-tip">
                        <strong>💡 Astuce :</strong> Utilisez le bouton "Télécharger Template CSV" pour obtenir un fichier avec le bon format.
                    </div>
                </div>

                <div class="guide-section">
                    <h4>
                        <svg fill="#1c6d9e" viewBox="0 0 24 24" style="width: 20px; height: 20px;">
                            <path d="M9,22A1,1 0 0,1 8,21V18H4A2,2 0 0,1 2,16V4C2,2.89 2.9,2 4,2H20A2,2 0 0,1 22,4V16A2,2 0 0,1 20,18H13.9L10.2,21.71C10,21.9 9.75,22 9.5,22V22H9Z"/>
                        </svg>
                        Exemple de contenu CSV
                    </h4>
                    <pre>URL Web 3CX,Identifiant 3CX,Mot de passe 3CX
https://3cx.client1.com,admin,MotDePasse123!
https://192.168.1.100,administrator,SecurePass456
https://pbx.entreprise.fr:5001,admin,P@ssw0rd789</pre>
                </div>

                <div class="guide-section">
                    <h4>
                        <svg fill="#1c6d9e" viewBox="0 0 24 24" style="width: 20px; height: 20px;">
                            <path d="M12,15.5A3.5,3.5 0 0,1 8.5,12A3.5,3.5 0 0,1 12,8.5A3.5,3.5 0 0,1 15.5,12A3.5,3.5 0 0,1 12,15.5M19.43,12.97C19.47,12.65 19.5,12.33 19.5,12C19.5,11.67 19.47,11.34 19.43,11L21.54,9.37C21.73,9.22 21.78,8.95 21.66,8.73L19.66,5.27C19.54,5.05 19.27,4.96 19.05,5.05L16.56,6.05C16.04,5.66 15.5,5.32 14.87,5.07L14.5,2.42C14.46,2.18 14.25,2 14,2H10C9.75,2 9.54,2.18 9.5,2.42L9.13,5.07C8.5,5.32 7.96,5.66 7.44,6.05L4.95,5.05C4.73,4.96 4.46,5.05 4.34,5.27L2.34,8.73C2.21,8.95 2.27,9.22 2.46,9.37L4.57,11C4.53,11.34 4.5,11.67 4.5,12C4.5,12.33 4.53,12.65 4.57,12.97L2.46,14.63C2.27,14.78 2.21,15.05 2.34,15.27L4.34,18.73C4.46,18.95 4.73,19.03 4.95,18.95L7.44,17.94C7.96,18.34 8.5,18.68 9.13,18.93L9.5,21.58C9.54,21.82 9.75,22 10,22H14C14.25,22 14.46,21.82 14.5,21.58L14.87,18.93C15.5,18.68 16.04,18.34 16.56,17.94L19.05,18.95C19.27,19.03 19.54,18.95 19.66,18.73L21.66,15.27C21.78,15.05 21.73,14.78 21.54,14.63L19.43,12.97Z"/>
                        </svg>
                        Configuration requise
                    </h4>
                    <ul style="margin-left: 20px; color: #495057;">
                        <li>Les URLs doivent commencer par <code>http://</code> ou <code>https://</code></li>
                        <li>Les ports personnalisés sont supportés (ex: <code>:5001</code>)</li>
                        <li>L'utilisateur doit avoir les droits administrateur sur le 3CX</li>
                        <li>Le serveur web doit pouvoir accéder aux serveurs 3CX</li>
                    </ul>
                </div>

                <div class="guide-section">
                    <h4>
                        <svg fill="#1c6d9e" viewBox="0 0 24 24" style="width: 20px; height: 20px;">
                            <path d="M17.65,6.35C16.2,4.9 14.21,4 12,4A8,8 0 0,0 4,12A8,8 0 0,0 12,20C15.73,20 18.84,17.45 19.73,14H17.65C16.83,16.33 14.61,18 12,18A6,6 0 0,1 6,12A6,6 0 0,1 12,6C13.66,6 15.14,6.69 16.22,7.78L13,11H20V4L17.65,6.35Z"/>
                        </svg>
                        Processus de vérification
                    </h4>
                    <p>Pour chaque serveur, le système va :</p>
                    <ol style="margin-left: 20px; color: #495057;">
                        <li>Se connecter avec les identifiants fournis</li>
                        <li>Récupérer la version actuelle installée</li>
                        <li>Vérifier les mises à jour disponibles (hors beta/alpha)</li>
                        <li>Afficher le statut dans le tableau</li>
                    </ol>
                </div>

                <div class="guide-section">
                    <h4>
                        <svg fill="#1c6d9e" viewBox="0 0 24 24" style="width: 20px; height: 20px;">
                            <path d="M19,8L15,12H18A6,6 0 0,1 12,18C11,18 10.03,17.75 9.2,17.3L7.74,18.76C8.97,19.54 10.43,20 12,20A8,8 0 0,0 20,12H23M6,12A6,6 0 0,1 12,6C13,6 13.97,6.25 14.8,6.7L16.26,5.24C15.03,4.46 13.57,4 12,4A8,8 0 0,0 4,12H1L5,16L9,12"/>
                        </svg>
                        Traitement par lots
                    </h4>
                    <p>Vous pouvez configurer le nombre de serveurs traités simultanément :</p>
                    <ul style="margin-left: 20px; color: #495057;">
                        <li><strong>5-10 serveurs :</strong> Recommandé pour une connexion standard</li>
                        <li><strong>15-20 serveurs :</strong> Pour une connexion rapide</li>
                        <li><strong>30-50 serveurs :</strong> Pour serveur dédié avec bonne bande passante</li>
                    </ul>
                    
                    <div class="guide-warning">
                        <strong>⚠️ Attention :</strong> Un nombre trop élevé peut surcharger votre serveur ou déclencher des protections anti-DDoS.
                    </div>
                </div>

                <div class="guide-section">
                    <h4>
                        <svg fill="#1c6d9e" viewBox="0 0 24 24" style="width: 20px; height: 20px;">
                            <path d="M14,12H15.5V14.82L17.94,16.23L17.19,17.53L14,15.69V12M4,2H18A2,2 0 0,1 20,4V10.1C21.24,11.36 22,13.09 22,15A7,7 0 0,1 15,22C13.09,22 11.36,21.24 10.1,20H4A2,2 0 0,1 2,18V4A2,2 0 0,1 4,2M4,15V18H8.67C8.24,17.09 8,16.07 8,15H4M4,8H10V5H4V8M18,8V5H12V8H18M4,13H8.29C8.63,11.85 9.26,10.82 10.1,10H4V13M15,10.15A4.85,4.85 0 0,0 10.15,15C10.15,17.68 12.32,19.85 15,19.85A4.85,4.85 0 0,0 19.85,15C19.85,12.32 17.68,10.15 15,10.15Z"/>
                        </svg>
                        Fonctionnalités avancées
                    </h4>
                    <ul style="margin-left: 20px; color: #495057;">
                        <li><strong>Filtres :</strong> Utilisez les onglets pour filtrer par statut</li>
                        <li><strong>Recherche :</strong> Recherchez dans toutes les colonnes</li>
                        <li><strong>Services :</strong> Cliquez sur le bouton bleu pour voir/redémarrer les services</li>
                        <li><strong>Dashboard :</strong> Vue d'ensemble avec statistiques et graphiques</li>
                        <li><strong>Sélection multiple :</strong> Cochez plusieurs serveurs pour actions groupées</li>
                    </ul>
                </div>

                <div class="guide-section">
                    <h4>
                        <svg fill="#dc3545" viewBox="0 0 24 24" style="width: 20px; height: 20px;">
                            <path d="M11,15H13V17H11V15M11,7H13V13H11V7M12,2C6.47,2 2,6.5 2,12A10,10 0 0,0 12,22A10,10 0 0,0 22,12A10,10 0 0,0 12,2M12,20A8,8 0 0,1 4,12A8,8 0 0,1 12,4A8,8 0 0,1 20,12A8,8 0 0,1 12,20Z"/>
                        </svg>
                        Résolution des problèmes
                    </h4>
                    <ul style="margin-left: 20px; color: #495057;">
                        <li><strong>Erreur de connexion :</strong> Vérifiez l'URL et les identifiants</li>
                        <li><strong>Timeout :</strong> Réduisez le nombre de serveurs par lot</li>
                        <li><strong>Version inconnue :</strong> Le serveur peut être trop ancien ou l'API différente</li>
                        <li><strong>Pas de mise à jour :</strong> Seules les versions stables sont affichées (pas de beta)</li>
                    </ul>
                </div>
            </div>
            <div class="modal-footer">
                <button class="btn btn-primary" onclick="closeGuideModal()">Fermer</button>
            </div>
        </div>
    </div>

    <!-- Charger Chart.js depuis CDN -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    
    <script>
        let serversData = [];
        let currentUpdateServer = null;
        let fileContent = null;
        let selectedServers = new Set();
        let currentBulkAction = null;
        let bulkProcessing = false;
        let currentFilter = 'all';
        let searchTerm = '';
        let currentServicesIndex = null;
        let statusChart = null;
        let progressChart = null;

        // Initialisation
        document.addEventListener('DOMContentLoaded', function() {
            // Vérifier si un fichier est stocké
            const savedFile = localStorage.getItem('3cx_csv_file');
            if (savedFile) {
                fileContent = savedFile;
                const fileName = localStorage.getItem('3cx_csv_filename') || 'Fichier sauvegardé';
                showFileInfo(fileName);
                document.getElementById('loadServersBtn').disabled = false;
                // Charger automatiquement les serveurs
                loadServers();
            }

            // Setup drag and drop
            const dropZone = document.getElementById('dropZone');
            
            dropZone.addEventListener('dragover', (e) => {
                e.preventDefault();
                dropZone.classList.add('dragover');
            });

            dropZone.addEventListener('dragleave', () => {
                dropZone.classList.remove('dragover');
            });

            dropZone.addEventListener('drop', (e) => {
                e.preventDefault();
                dropZone.classList.remove('dragover');
                
                const files = e.dataTransfer.files;
                if (files.length > 0) {
                    handleFile(files[0]);
                }
            });

            document.getElementById('csvFile').addEventListener('change', (e) => {
                if (e.target.files.length > 0) {
                    handleFile(e.target.files[0]);
                }
            });
        });

        function handleFile(file) {
            if (!file.name.endsWith('.csv')) {
                showAlert('Veuillez sélectionner un fichier CSV', 'error');
                return;
            }

            const reader = new FileReader();
            reader.onload = function(e) {
                fileContent = e.target.result;
                localStorage.setItem('3cx_csv_file', fileContent);
                localStorage.setItem('3cx_csv_filename', file.name);
                showFileInfo(file.name);
                document.getElementById('loadServersBtn').disabled = false;
                showAlert('Fichier chargé avec succès', 'success');
            };
            reader.readAsText(file);
        }

        function showFileInfo(fileName) {
            document.getElementById('fileName').textContent = fileName;
            document.getElementById('fileInfo').classList.add('active');
        }

        function clearFile() {
            fileContent = null;
            localStorage.removeItem('3cx_csv_file');
            localStorage.removeItem('3cx_csv_filename');
            document.getElementById('fileInfo').classList.remove('active');
            document.getElementById('loadServersBtn').disabled = true;
            document.getElementById('serversSection').style.display = 'none';
            selectedServers.clear();
            showAlert('Fichier supprimé', 'info');
        }

        function parseCSV(csv) {
            const lines = csv.split('\n');
            const headers = lines[0].split(',').map(h => h.trim().replace(/"/g, ''));
            const servers = [];

            for (let i = 1; i < lines.length; i++) {
                if (lines[i].trim() === '') continue;
                
                const values = lines[i].split(',').map(v => v.trim().replace(/"/g, ''));
                const server = {};
                
                headers.forEach((header, index) => {
                    server[header] = values[index] || '';
                });
                
                servers.push(server);
            }
            
            return servers;
        }

        function loadServers() {
            if (!fileContent) {
                showAlert('Aucun fichier chargé', 'error');
                return;
            }

            serversData = parseCSV(fileContent);
            
            if (serversData.length === 0) {
                showAlert('Aucun serveur trouvé dans le fichier', 'warning');
                return;
            }

            selectedServers.clear();
            displayServers(); // Cela va aussi restaurer les données
            document.getElementById('serversSection').style.display = 'block';
            document.getElementById('serverCount').textContent = `${serversData.length} serveur(s)`;
            document.getElementById('dashboardBtn').style.display = 'inline-flex';
            
            // Vérifier s'il y a des données sauvegardées
            const savedState = localStorage.getItem('3cx_servers_state');
            if (savedState) {
                try {
                    const state = JSON.parse(savedState);
                    const savedTime = new Date(state.timestamp);
                    const timeAgo = formatTimeAgo(savedTime);
                    showAlert(`📊 ${serversData.length} serveur(s) chargé(s) - Données restaurées (${timeAgo})`, 'info');
                    updateLastCheckIndicator();
                } catch (e) {
                    showAlert(`${serversData.length} serveur(s) chargé(s)`, 'success');
                }
            } else {
                showAlert(`${serversData.length} serveur(s) chargé(s)`, 'success');
            }
            
            updateDashboard();
        }

        // Sauvegarder l'état des serveurs
        function saveServersState() {
            const state = {
                timestamp: new Date().toISOString(),
                servers: []
            };
            
            serversData.forEach((server, index) => {
                const row = document.getElementById(`server-row-${index}`);
                if (!row) return;
                
                const serverState = {
                    url: server['URL Web 3CX'],
                    username: server['Identifiant 3CX'],
                    status: row.dataset.status || 'pending',
                    currentVersion: document.getElementById(`version-${index}`).textContent || '-',
                    newVersion: document.getElementById(`new-version-${index}`).textContent || '-',
                    statusText: document.getElementById(`status-${index}`).textContent || 'En attente',
                    updateInfo: server.updateInfo || null
                };
                
                state.servers.push(serverState);
            });
            
            localStorage.setItem('3cx_servers_state', JSON.stringify(state));
            updateLastCheckIndicator();
        }

        // Charger l'état sauvegardé
        function loadServersState() {
            const savedState = localStorage.getItem('3cx_servers_state');
            if (!savedState) return;
            
            try {
                const state = JSON.parse(savedState);
                
                // Vérifier si les données ne sont pas trop anciennes (24h)
                const savedTime = new Date(state.timestamp);
                const now = new Date();
                const hoursDiff = (now - savedTime) / (1000 * 60 * 60);
                
                if (hoursDiff > 24) {
                    localStorage.removeItem('3cx_servers_state');
                    showAlert('Les données sauvegardées ont plus de 24h et ont été effacées', 'info');
                    return;
                }
                
                // Afficher l'âge des données
                const timeAgo = formatTimeAgo(savedTime);
                showAlert(`📊 Données restaurées (dernière vérification ${timeAgo})`, 'info');
                
                // Mettre à jour l'indicateur
                updateLastCheckIndicator();
                
                return state;
            } catch (e) {
                console.error('Erreur lors du chargement de l\'état:', e);
                localStorage.removeItem('3cx_servers_state');
            }
        }

        // Restaurer les données des serveurs
        function restoreServersData() {
            const savedState = localStorage.getItem('3cx_servers_state');
            if (!savedState) {
                return;
            }
            
            try {
                const state = JSON.parse(savedState);
                
                // Vérifier si les données ne sont pas trop anciennes (24h)
                const savedTime = new Date(state.timestamp);
                const now = new Date();
                const hoursDiff = (now - savedTime) / (1000 * 60 * 60);
                
                if (hoursDiff > 24) {
                    localStorage.removeItem('3cx_servers_state');
                    return;
                }
                
                state.servers.forEach(savedServer => {
                    // Trouver le serveur correspondant par URL et username
                    const serverIndex = serversData.findIndex(s => 
                        s['URL Web 3CX'] === savedServer.url && 
                        s['Identifiant 3CX'] === savedServer.username
                    );
                    
                    if (serverIndex === -1) {
                        return;
                    }
                    
                    // Restaurer les données
                    const row = document.getElementById(`server-row-${serverIndex}`);
                    if (row) {
                        row.dataset.status = savedServer.status;
                    }
                    
                    // Restaurer la version actuelle
                    if (savedServer.currentVersion && savedServer.currentVersion !== '-') {
                        document.getElementById(`version-${serverIndex}`).textContent = savedServer.currentVersion;
                    }
                    
                    // Restaurer la nouvelle version
                    if (savedServer.newVersion && savedServer.newVersion !== '-') {
                        document.getElementById(`new-version-${serverIndex}`).textContent = savedServer.newVersion;
                    }
                    
                    // Restaurer le statut
                    if (savedServer.statusText) {
                        const statusClass = getStatusClass(savedServer.status);
                        document.getElementById(`status-${serverIndex}`).innerHTML = 
                            `<span class="status-badge ${statusClass}">${savedServer.statusText.trim()}</span>`;
                    }
                    
                    // Restaurer updateInfo si présent
                    if (savedServer.updateInfo) {
                        serversData[serverIndex].updateInfo = savedServer.updateInfo;
                        
                        // Restaurer le bouton de mise à jour si nécessaire
                        if (savedServer.status === 'available') {
                            document.getElementById(`actions-${serverIndex}`).innerHTML = `
                                <button class="btn btn-success btn-sm" onclick="promptUpdate(${serverIndex})">
                                    Mettre à jour
                                </button>
                                <button class="btn btn-info btn-sm" onclick="viewServices(${serverIndex})" title="Voir les services">
                                    <svg fill="white" viewBox="0 0 24 24" style="width: 16px; height: 16px;">
                                        <path d="M3,13H5V11H3V13M3,17H5V15H3V17M3,9H5V7H3V9M7,13H21V11H7V13M7,17H21V15H7V17M7,7V9H21V7H7Z"/>
                                    </svg>
                                </button>
                            `;
                        } else if (savedServer.status === 'updated') {
                            document.getElementById(`actions-${serverIndex}`).innerHTML = `
                                <button class="btn btn-primary btn-sm" onclick="checkUpdate(${serverIndex})">
                                    Vérifier
                                </button>
                                <button class="btn btn-info btn-sm" onclick="viewServices(${serverIndex})" title="Voir les services">
                                    <svg fill="white" viewBox="0 0 24 24" style="width: 16px; height: 16px;">
                                        <path d="M3,13H5V11H3V13M3,17H5V15H3V17M3,9H5V7H3V9M7,13H21V11H7V13M7,17H21V15H7V17M7,7V9H21V7H7Z"/>
                                    </svg>
                                </button>
                            `;
                        }
                    }
                });
                
                updateFilterCounts();
                updateDashboard();
                
            } catch (e) {
                console.error('Erreur lors de la restauration des données:', e);
                localStorage.removeItem('3cx_servers_state');
            }
        }

        // Formater le temps écoulé
        function formatTimeAgo(date) {
            const seconds = Math.floor((new Date() - date) / 1000);
            
            const intervals = {
                année: 31536000,
                mois: 2592000,
                semaine: 604800,
                jour: 86400,
                heure: 3600,
                minute: 60
            };
            
            for (let [unit, secondsInUnit] of Object.entries(intervals)) {
                const interval = Math.floor(seconds / secondsInUnit);
                if (interval >= 1) {
                    return `il y a ${interval} ${unit}${interval > 1 ? 's' : ''}`;
                }
            }
            
            return 'à l\'instant';
        }

        // Obtenir la classe de statut
        function getStatusClass(status) {
            switch(status) {
                case 'available': return 'status-available';
                case 'updated': return 'status-updated';
                case 'error': return 'status-error';
                case 'checking': return 'status-checking';
                case 'updating': return 'status-updating';
                default: return 'status-checking';
            }
        }

        function displayServers() {
            const tbody = document.getElementById('serversTableBody');
            tbody.innerHTML = '';

            serversData.forEach((server, index) => {
                const row = document.createElement('tr');
                row.id = `server-row-${index}`;
                row.dataset.status = 'pending'; // Statut par défaut
                row.innerHTML = `
                    <td class="checkbox-cell">
                        <input type="checkbox" id="checkbox-${index}" onchange="toggleServerSelection(${index})">
                    </td>
                    <td>${index + 1}</td>
                    <td>
                        <div class="tooltip">
                            ${server['URL Web 3CX'] || '-'}
                            <span class="tooltiptext">${server['URL Web 3CX'] || 'Non défini'}</span>
                        </div>
                    </td>
                    <td>${server['Identifiant 3CX'] || '-'}</td>
                    <td id="version-${index}">-</td>
                    <td id="new-version-${index}">-</td>
                    <td id="status-${index}">
                        <span class="status-badge status-checking">En attente</span>
                    </td>
                    <td id="actions-${index}">
                        <button class="btn btn-primary btn-sm" onclick="checkUpdate(${index})">
                            Vérifier
                        </button>
                        <button class="btn btn-info btn-sm" onclick="viewServices(${index})" title="Voir les services">
                            <svg fill="white" viewBox="0 0 24 24" style="width: 16px; height: 16px;">
                                <path d="M3,13H5V11H3V13M3,17H5V15H3V17M3,9H5V7H3V9M7,13H21V11H7V13M7,17H21V15H7V17M7,7V9H21V7H7Z"/>
                            </svg>
                        </button>
                    </td>
                `;
                tbody.appendChild(row);
            });
            
            // Restaurer les données sauvegardées APRÈS avoir créé les lignes
            restoreServersData();
            updateFilterCounts();
        }

        function searchTable() {
            const input = document.getElementById('searchInput');
            searchTerm = input.value.toLowerCase().trim();
            
            // Afficher/masquer le bouton clear
            const clearBtn = document.getElementById('clearSearchBtn');
            const searchResults = document.getElementById('searchResults');
            
            if (searchTerm) {
                clearBtn.style.display = 'flex';
                searchResults.style.display = 'block';
            } else {
                clearBtn.style.display = 'none';
                searchResults.style.display = 'none';
            }
            
            let visibleCount = 0;
            let matchCount = 0;
            
            serversData.forEach((server, index) => {
                const row = document.getElementById(`server-row-${index}`);
                if (!row) return;
                
                // Récupérer tous les textes de la ligne
                const url = (server['URL Web 3CX'] || '').toLowerCase();
                const username = (server['Identifiant 3CX'] || '').toLowerCase();
                const version = (document.getElementById(`version-${index}`).textContent || '').toLowerCase();
                const newVersion = (document.getElementById(`new-version-${index}`).textContent || '').toLowerCase();
                const status = (document.getElementById(`status-${index}`).textContent || '').toLowerCase();
                
                // Vérifier si le terme de recherche est présent
                const matches = searchTerm === '' || 
                    url.includes(searchTerm) || 
                    username.includes(searchTerm) || 
                    version.includes(searchTerm) || 
                    newVersion.includes(searchTerm) || 
                    status.includes(searchTerm) ||
                    (index + 1).toString().includes(searchTerm); // Numéro de ligne
                
                if (matches) {
                    row.classList.remove('search-hidden');
                    matchCount++;
                    
                    // Compter seulement si aussi visible par le filtre
                    if (!row.classList.contains('hidden')) {
                        visibleCount++;
                    }
                    
                    // Mettre en surbrillance les termes trouvés
                    if (searchTerm) {
                        highlightSearchTerms(row, searchTerm);
                    } else {
                        removeHighlights(row);
                    }
                } else {
                    row.classList.add('search-hidden');
                    removeHighlights(row);
                }
            });
            
            // Mettre à jour le compteur de résultats
            if (searchTerm) {
                document.getElementById('searchResultsText').textContent = 
                    `${matchCount} résultat(s) trouvé(s)${currentFilter !== 'all' ? ` (${visibleCount} visible(s) avec le filtre actuel)` : ''}`;
            }
            
            // Mettre à jour la sélection si nécessaire
            updateSelectionInfo();
        }

        function highlightSearchTerms(row, term) {
            // Fonction pour mettre en surbrillance le terme recherché
            const cells = row.querySelectorAll('td:not(.checkbox-cell)');
            cells.forEach(cell => {
                const originalText = cell.getAttribute('data-original-text');
                if (!originalText) {
                    cell.setAttribute('data-original-text', cell.innerHTML);
                }
                
                // Éviter de modifier les boutons et badges
                const textNodes = [];
                const walker = document.createTreeWalker(
                    cell,
                    NodeFilter.SHOW_TEXT,
                    {
                        acceptNode: function(node) {
                            if (node.parentElement.tagName === 'BUTTON' || 
                                node.parentElement.classList.contains('status-badge') ||
                                node.parentElement.classList.contains('tooltiptext')) {
                                return NodeFilter.FILTER_REJECT;
                            }
                            return NodeFilter.FILTER_ACCEPT;
                        }
                    },
                    false
                );
                
                let node;
                while (node = walker.nextNode()) {
                    textNodes.push(node);
                }
                
                textNodes.forEach(textNode => {
                    const text = textNode.textContent;
                    const regex = new RegExp(`(${term})`, 'gi');
                    if (regex.test(text)) {
                        const span = document.createElement('span');
                        span.innerHTML = text.replace(regex, '<span class="highlight">$1</span>');
                        textNode.parentNode.replaceChild(span, textNode);
                    }
                });
            });
        }

        function removeHighlights(row) {
            const cells = row.querySelectorAll('td:not(.checkbox-cell)');
            cells.forEach(cell => {
                const originalText = cell.getAttribute('data-original-text');
                if (originalText) {
                    // Restaurer seulement le texte, pas le HTML complet
                    const highlights = cell.querySelectorAll('.highlight');
                    highlights.forEach(highlight => {
                        const textNode = document.createTextNode(highlight.textContent);
                        highlight.parentNode.replaceChild(textNode, highlight);
                    });
                }
            });
        }

        function clearSearch() {
            document.getElementById('searchInput').value = '';
            searchTerm = '';
            searchTable();
        }

        function filterServers(filter) {
            currentFilter = filter;
            
            // Mettre à jour les tabs actifs
            document.querySelectorAll('.filter-tab').forEach(tab => {
                tab.classList.remove('active');
            });
            document.getElementById(`tab-${filter}`).classList.add('active');
            
            // Filtrer les lignes
            serversData.forEach((_, index) => {
                const row = document.getElementById(`server-row-${index}`);
                if (!row) return;
                
                const status = row.dataset.status;
                let shouldShow = false;
                
                switch(filter) {
                    case 'all':
                        shouldShow = true;
                        break;
                    case 'updates':
                        shouldShow = status === 'available';
                        break;
                    case 'updated':
                        shouldShow = status === 'updated';
                        break;
                    case 'error':
                        shouldShow = status === 'error';
                        break;
                    case 'pending':
                        shouldShow = status === 'pending' || status === 'checking';
                        break;
                }
                
                if (shouldShow) {
                    row.classList.remove('hidden');
                } else {
                    row.classList.add('hidden');
                }
            });
            
            // Réappliquer la recherche si nécessaire
            if (searchTerm) {
                searchTable();
            }
            
            // Désélectionner les serveurs cachés
            serversData.forEach((_, index) => {
                const row = document.getElementById(`server-row-${index}`);
                const checkbox = document.getElementById(`checkbox-${index}`);
                if (row && row.classList.contains('hidden') && checkbox && checkbox.checked) {
                    checkbox.checked = false;
                    selectedServers.delete(index);
                    row.classList.remove('selected');
                }
            });
            
            updateSelectionInfo();
        }

        function updateFilterCounts() {
            const counts = {
                all: 0,
                updates: 0,
                updated: 0,
                error: 0,
                pending: 0
            };
            
            serversData.forEach((_, index) => {
                const row = document.getElementById(`server-row-${index}`);
                if (!row) return;
                
                const status = row.dataset.status;
                counts.all++;
                
                switch(status) {
                    case 'available':
                        counts.updates++;
                        break;
                    case 'updated':
                        counts.updated++;
                        break;
                    case 'error':
                        counts.error++;
                        break;
                    case 'pending':
                    case 'checking':
                        counts.pending++;
                        break;
                }
            });
            
            document.getElementById('count-all').textContent = counts.all;
            document.getElementById('count-updates').textContent = counts.updates;
            document.getElementById('count-updated').textContent = counts.updated;
            document.getElementById('count-error').textContent = counts.error;
            document.getElementById('count-pending').textContent = counts.pending;
        }

        function selectAllVisible() {
            serversData.forEach((_, index) => {
                const row = document.getElementById(`server-row-${index}`);
                const checkbox = document.getElementById(`checkbox-${index}`);
                
                // Sélectionner seulement si visible (ni hidden par filtre, ni search-hidden par recherche)
                if (row && !row.classList.contains('hidden') && !row.classList.contains('search-hidden') && checkbox) {
                    checkbox.checked = true;
                    selectedServers.add(index);
                    row.classList.add('selected');
                }
            });
            
            updateSelectionInfo();
        }

        function toggleServerSelection(index) {
            const checkbox = document.getElementById(`checkbox-${index}`);
            const row = document.getElementById(`server-row-${index}`);
            
            if (checkbox.checked) {
                selectedServers.add(index);
                row.classList.add('selected');
            } else {
                selectedServers.delete(index);
                row.classList.remove('selected');
            }
            
            updateSelectionInfo();
        }

        function toggleSelectAll() {
            const selectAllCheckbox = document.getElementById('selectAllCheckbox');
            
            if (selectAllCheckbox.checked) {
                selectAll();
            } else {
                deselectAll();
            }
        }

        function selectAll() {
            serversData.forEach((_, index) => {
                const checkbox = document.getElementById(`checkbox-${index}`);
                const row = document.getElementById(`server-row-${index}`);
                if (checkbox) {
                    checkbox.checked = true;
                    selectedServers.add(index);
                    row.classList.add('selected');
                }
            });
            document.getElementById('selectAllCheckbox').checked = true;
            updateSelectionInfo();
        }

        function deselectAll() {
            selectedServers.clear();
            serversData.forEach((_, index) => {
                const checkbox = document.getElementById(`checkbox-${index}`);
                const row = document.getElementById(`server-row-${index}`);
                if (checkbox) {
                    checkbox.checked = false;
                    row.classList.remove('selected');
                }
            });
            document.getElementById('selectAllCheckbox').checked = false;
            updateSelectionInfo();
        }

        function updateSelectionInfo() {
            const count = selectedServers.size;
            document.getElementById('selectedCount').textContent = count;
            
            // Activer/désactiver les boutons d'action groupée
            document.getElementById('bulkCheckBtn').disabled = count === 0;
            
            // Activer le bouton de mise à jour seulement si des serveurs sélectionnés ont des mises à jour
            let hasUpdates = false;
            selectedServers.forEach(index => {
                if (serversData[index].updateInfo) {
                    hasUpdates = true;
                }
            });
            document.getElementById('bulkUpdateBtn').disabled = !hasUpdates;
        }

        async function checkUpdate(serverIndex) {
            const server = serversData[serverIndex];
            updateStatus(serverIndex, 'Vérification...', 'status-checking');
            
            try {
                const response = await fetch('3cx_api.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                    },
                    body: JSON.stringify({
                        action: 'check_update',
                        server: {
                            url: server['URL Web 3CX'],
                            username: server['Identifiant 3CX'],
                            password: server['Mot de passe 3CX']
                        }
                    })
                });

                // Vérifier le statut HTTP
                if (!response.ok) {
                    throw new Error(`HTTP error! status: ${response.status}`);
                }

                // Essayer de parser le JSON
                let result;
                try {
                    const responseText = await response.text();
                    
                    if (!responseText) {
                        throw new Error('Réponse vide du serveur');
                    }
                    
                    result = JSON.parse(responseText);
                } catch (jsonError) {
                    throw new Error('Réponse invalide du serveur');
                }
                
                if (result && result.success) {
                    // Mettre à jour la version actuelle
                    document.getElementById(`version-${serverIndex}`).textContent = result.current_version || '-';
                    
                    // Vérifier les mises à jour
                    if (result.updates && Array.isArray(result.updates) && result.updates.length > 0) {
                        const latestUpdate = result.updates[0];
                        document.getElementById(`new-version-${serverIndex}`).textContent = latestUpdate.Version || '-';
                        updateStatus(serverIndex, 'Mise à jour disponible', 'status-available');
                        
                        // Stocker les infos de mise à jour
                        serversData[serverIndex].updateInfo = {
                            system_key: result.system_key,
                            update_guid: latestUpdate.Guid,
                            new_version: latestUpdate.Version
                        };
                        
                        document.getElementById(`actions-${serverIndex}`).innerHTML = `
                            <button class="btn btn-success btn-sm" onclick="promptUpdate(${serverIndex})">
                                Mettre à jour
                            </button>
                            <button class="btn btn-info btn-sm" onclick="viewServices(${serverIndex})" title="Voir les services">
                                <svg fill="white" viewBox="0 0 24 24" style="width: 16px; height: 16px;">
                                    <path d="M3,13H5V11H3V13M3,17H5V15H3V17M3,9H5V7H3V9M7,13H21V11H7V13M7,17H21V15H7V17M7,7V9H21V7H7Z"/>
                                </svg>
                            </button>
                        `;
                    } else {
                        // Pas de mise à jour disponible
                        document.getElementById(`new-version-${serverIndex}`).textContent = '-';
                        updateStatus(serverIndex, 'À jour', 'status-updated');
                        
                        // Retirer l'info de mise à jour si elle existait
                        if (serversData[serverIndex].updateInfo) {
                            delete serversData[serverIndex].updateInfo;
                        }
                        
                        // Remettre les boutons standards
                        document.getElementById(`actions-${serverIndex}`).innerHTML = `
                            <button class="btn btn-primary btn-sm" onclick="checkUpdate(${serverIndex})">
                                Vérifier
                            </button>
                            <button class="btn btn-info btn-sm" onclick="viewServices(${serverIndex})" title="Voir les services">
                                <svg fill="white" viewBox="0 0 24 24" style="width: 16px; height: 16px;">
                                    <path d="M3,13H5V11H3V13M3,17H5V15H3V17M3,9H5V7H3V9M7,13H21V11H7V13M7,17H21V15H7V17M7,7V9H21V7H7Z"/>
                                </svg>
                            </button>
                        `;
                    }
                    
                    // Mettre à jour l'état des boutons d'action groupée
                    updateSelectionInfo();
                    
                    // Sauvegarder l'état APRÈS avoir tout mis à jour
                    setTimeout(() => {
                        saveServersState();
                    }, 100);
                    
                    return true; // Succès
                } else {
                    // Erreur retournée par le serveur
                    updateStatus(serverIndex, 'Erreur', 'status-error');
                    
                    if (result && result.message) {
                        showAlert(`Erreur serveur ${serverIndex + 1}: ${result.message}`, 'error');
                    } else {
                        showAlert(`Erreur serveur ${serverIndex + 1}: Réponse invalide`, 'error');
                    }
                    return false;
                }
            } catch (error) {
                // Vérifier si on a quand même récupéré la version
                const currentVersion = document.getElementById(`version-${serverIndex}`).textContent;
                if (currentVersion && currentVersion !== '-' && currentVersion !== 'Vérification...') {
                    // On a la version, donc c'est probablement juste un problème de parsing
                    document.getElementById(`new-version-${serverIndex}`).textContent = '-';
                    updateStatus(serverIndex, 'À jour', 'status-updated');
                    
                    // Sauvegarder l'état
                    setTimeout(() => {
                        saveServersState();
                    }, 100);
                } else {
                    // Vraie erreur de connexion
                    updateStatus(serverIndex, 'Erreur connexion', 'status-error');
                    showAlert(`Erreur de connexion au serveur ${serverIndex + 1}: ${error.message}`, 'error');
                }
                
                return false;
            }
        }

        async function checkSelectedServers() {
            if (selectedServers.size === 0) {
                showAlert('Aucun serveur sélectionné', 'warning');
                return;
            }

            const batchSize = parseInt(document.getElementById('batchSize').value) || 10;
            currentBulkAction = 'check';
            const serversList = Array.from(selectedServers).map(index => {
                const server = serversData[index];
                return `• ${server['URL Web 3CX']}`;
            }).join('<br>');

            document.getElementById('bulkModalTitle').textContent = 'Vérifier les mises à jour';
            document.getElementById('bulkModalBody').innerHTML = `
                <p>Vous allez vérifier les mises à jour pour <strong>${selectedServers.size}</strong> serveur(s)</p>
                <p>Les serveurs seront traités par lots de <strong>${batchSize}</strong> en parallèle.</p>
                <div class="server-list">
                    ${serversList}
                </div>
                <div class="alert alert-info" style="margin-top: 15px;">
                    <strong>💡 Info :</strong> Le traitement par lots permet de vérifier plusieurs serveurs simultanément, réduisant considérablement le temps total.
                </div>
            `;
            document.getElementById('bulkModal').classList.add('active');
        }

        async function updateSelectedServers() {
            const serversWithUpdates = [];
            selectedServers.forEach(index => {
                if (serversData[index].updateInfo) {
                    serversWithUpdates.push(index);
                }
            });

            if (serversWithUpdates.length === 0) {
                showAlert('Aucun serveur sélectionné n\'a de mise à jour disponible', 'warning');
                return;
            }

            const batchSize = Math.min(5, Math.floor(parseInt(document.getElementById('batchSize').value) / 2) || 5);
            currentBulkAction = 'update';
            const serversList = serversWithUpdates.map(index => {
                const server = serversData[index];
                return `• ${server['URL Web 3CX']} → ${server.updateInfo.new_version}`;
            }).join('<br>');

            document.getElementById('bulkModalTitle').textContent = 'Installer les mises à jour';
            document.getElementById('bulkModalBody').innerHTML = `
                <p>Vous allez installer les mises à jour pour <strong>${serversWithUpdates.length}</strong> serveur(s)</p>
                <p>Les serveurs seront traités par lots de <strong>${batchSize}</strong> en parallèle (réduit pour les mises à jour).</p>
                <div class="server-list">
                    ${serversList}
                </div>
                <div class="alert alert-warning" style="margin-top: 15px;">
                    <strong>⚠️ Attention :</strong> Les serveurs vont redémarrer après la mise à jour.
                </div>
            `;
            document.getElementById('bulkModal').classList.add('active');
        }

        async function confirmBulkAction() {
            if (currentBulkAction === 'check') {
                await executeBulkCheck();
            } else if (currentBulkAction === 'update') {
                await executeBulkUpdate();
            }
        }

        async function executeBulkCheck() {
            bulkProcessing = true;
            const serversToCheck = Array.from(selectedServers);
            const total = serversToCheck.length;
            const BATCH_SIZE = parseInt(document.getElementById('batchSize').value) || 10;
            
            // Masquer les boutons et afficher la progression
            document.getElementById('bulkModalFooter').style.display = 'none';
            document.getElementById('progressContainer').style.display = 'block';
            
            document.getElementById('progressText').textContent = `Traitement par lots de ${BATCH_SIZE} serveurs...`;
            
            let processed = 0;
            
            // Traiter par lots
            for (let i = 0; i < serversToCheck.length; i += BATCH_SIZE) {
                if (!bulkProcessing) break; // Permettre l'annulation
                
                const batch = serversToCheck.slice(i, Math.min(i + BATCH_SIZE, serversToCheck.length));
                const batchNumber = Math.floor(i / BATCH_SIZE) + 1;
                const totalBatches = Math.ceil(serversToCheck.length / BATCH_SIZE);
                
                // Lancer toutes les vérifications du lot en parallèle
                const promises = batch.map(serverIndex => {
                    return checkUpdate(serverIndex).then((success) => {
                        processed++;
                        const progress = (processed / total) * 100;
                        document.getElementById('progressFill').style.width = `${progress}%`;
                        document.getElementById('progressText').textContent = `Lot ${batchNumber}/${totalBatches} - ${processed} / ${total} serveurs vérifiés`;
                        return success;
                    }).catch(error => {
                        processed++;
                        const progress = (processed / total) * 100;
                        document.getElementById('progressFill').style.width = `${progress}%`;
                        document.getElementById('progressText').textContent = `Lot ${batchNumber}/${totalBatches} - ${processed} / ${total} serveurs vérifiés`;
                        return false;
                    });
                });
                
                // Attendre que tout le lot soit terminé avant de passer au suivant
                await Promise.all(promises);
                
                // Petit délai entre les lots pour ne pas surcharger
                if (i + BATCH_SIZE < serversToCheck.length) {
                    await new Promise(resolve => setTimeout(resolve, 200));
                }
            }
            
            bulkProcessing = false;
            closeBulkModal();
            showAlert(`✅ Vérification terminée pour ${total} serveur(s) (traités par lots de ${BATCH_SIZE})`, 'success');
            
            // Sauvegarder l'état après la vérification groupée
            saveServersState();
        }

        async function executeBulkUpdate() {
            bulkProcessing = true;
            const serversToUpdate = [];
            selectedServers.forEach(index => {
                if (serversData[index].updateInfo) {
                    serversToUpdate.push(index);
                }
            });
            
            const total = serversToUpdate.length;
            // Utiliser un lot plus petit pour les mises à jour (plus critiques)
            const BATCH_SIZE = Math.min(5, Math.floor(parseInt(document.getElementById('batchSize').value) / 2) || 5);
            
            // Masquer les boutons et afficher la progression
            document.getElementById('bulkModalFooter').style.display = 'none';
            document.getElementById('progressContainer').style.display = 'block';
            
            document.getElementById('progressText').textContent = `Traitement par lots de ${BATCH_SIZE} serveurs...`;
            
            let successCount = 0;
            let errorCount = 0;
            let processed = 0;
            
            // Traiter par lots
            for (let i = 0; i < serversToUpdate.length; i += BATCH_SIZE) {
                if (!bulkProcessing) break; // Permettre l'annulation
                
                const batch = serversToUpdate.slice(i, Math.min(i + BATCH_SIZE, serversToUpdate.length));
                const batchNumber = Math.floor(i / BATCH_SIZE) + 1;
                const totalBatches = Math.ceil(serversToUpdate.length / BATCH_SIZE);
                
                // Préparer toutes les mises à jour du lot
                const promises = batch.map(serverIndex => {
                    const server = serversData[serverIndex];
                    
                    updateStatus(serverIndex, 'Mise à jour en cours...', 'status-updating');
                    document.getElementById(`actions-${serverIndex}`).innerHTML = `<div class="loading-spinner"></div>`;
                    
                    return fetch('3cx_api.php', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                        },
                        body: JSON.stringify({
                            action: 'install_update',
                            server: {
                                url: server['URL Web 3CX'],
                                username: server['Identifiant 3CX'],
                                password: server['Mot de passe 3CX']
                            },
                            update_info: server.updateInfo
                        })
                    })
                    .then(response => response.json())
                    .then(result => {
                        processed++;
                        
                        if (result.success) {
                            updateStatus(serverIndex, 'Mise à jour lancée', 'status-updated');
                            document.getElementById(`actions-${serverIndex}`).innerHTML = `
                                <button class="btn btn-primary btn-sm" onclick="checkUpdate(${serverIndex})">
                                    Revérifier
                                </button>
                            `;
                            successCount++;
                        } else {
                            updateStatus(serverIndex, 'Échec mise à jour', 'status-error');
                            document.getElementById(`actions-${serverIndex}`).innerHTML = `
                                <button class="btn btn-success btn-sm" onclick="promptUpdate(${serverIndex})">
                                    Réessayer
                                </button>
                            `;
                            errorCount++;
                        }
                        
                        const progress = (processed / total) * 100;
                        document.getElementById('progressFill').style.width = `${progress}%`;
                        document.getElementById('progressText').textContent = `Lot ${batchNumber}/${totalBatches} - ${processed} / ${total} - ✅ ${successCount} réussite(s), ❌ ${errorCount} échec(s)`;
                    })
                    .catch(error => {
                        processed++;
                        updateStatus(serverIndex, 'Erreur', 'status-error');
                        errorCount++;
                        
                        const progress = (processed / total) * 100;
                        document.getElementById('progressFill').style.width = `${progress}%`;
                        document.getElementById('progressText').textContent = `Lot ${batchNumber}/${totalBatches} - ${processed} / ${total} - ✅ ${successCount} réussite(s), ❌ ${errorCount} échec(s)`;
                    });
                });
                
                // Attendre que tout le lot soit terminé
                await Promise.all(promises);
                
                // Délai entre les lots
                if (i + BATCH_SIZE < serversToUpdate.length) {
                    await new Promise(resolve => setTimeout(resolve, 500));
                }
            }
            
            bulkProcessing = false;
            closeBulkModal();
            
            let message = `✅ Mise à jour terminée : ${successCount} réussite(s)`;
            if (errorCount > 0) {
                message += `, ❌ ${errorCount} échec(s)`;
            }
            message += ` (traités par lots de ${BATCH_SIZE})`;
            showAlert(message, successCount > 0 ? 'success' : 'error');
            
            // Sauvegarder l'état après les mises à jour
            saveServersState();
        }

        function updateStatus(serverIndex, text, className) {
            const statusElement = document.getElementById(`status-${serverIndex}`);
            statusElement.innerHTML = `<span class="status-badge ${className}">${text}</span>`;
            
            // Mettre à jour le data-status de la ligne
            const row = document.getElementById(`server-row-${serverIndex}`);
            if (row) {
                // Mapper les classes de statut aux valeurs de filtre
                if (className === 'status-available') {
                    row.dataset.status = 'available';
                } else if (className === 'status-updated') {
                    row.dataset.status = 'updated';
                } else if (className === 'status-error') {
                    row.dataset.status = 'error';
                } else if (className === 'status-checking' || className === 'status-updating') {
                    row.dataset.status = 'checking';
                } else {
                    row.dataset.status = 'pending';
                }
            }
            
            // Mettre à jour les compteurs
            updateFilterCounts();
            updateDashboard();
            
            // Appliquer le filtre actuel
            if (currentFilter !== 'all') {
                filterServers(currentFilter);
            }
            
            // Réappliquer la recherche si nécessaire
            if (searchTerm) {
                searchTable();
            }
        }

        function promptUpdate(serverIndex) {
            const server = serversData[serverIndex];
            currentUpdateServer = serverIndex;
            
            const modalBody = document.getElementById('modalBody');
            modalBody.innerHTML = `
                <p><strong>Serveur :</strong> ${server['URL Web 3CX']}</p>
                <p><strong>Version actuelle :</strong> ${document.getElementById(`version-${serverIndex}`).textContent}</p>
                <p><strong>Nouvelle version :</strong> ${server.updateInfo.new_version}</p>
                <br>
                <div class="alert alert-warning">
                    <strong>⚠️ Attention :</strong> Le serveur va redémarrer après la mise à jour.
                </div>
            `;
            
            document.getElementById('confirmModal').classList.add('active');
        }

        async function confirmUpdate() {
            if (currentUpdateServer === null) return;
            
            const serverIndex = currentUpdateServer;
            const server = serversData[serverIndex];
            
            closeModal();
            updateStatus(serverIndex, 'Mise à jour en cours...', 'status-updating');
            
            document.getElementById(`actions-${serverIndex}`).innerHTML = `
                <div class="loading-spinner"></div>
            `;
            
            try {
                const response = await fetch('3cx_api.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                    },
                    body: JSON.stringify({
                        action: 'install_update',
                        server: {
                            url: server['URL Web 3CX'],
                            username: server['Identifiant 3CX'],
                            password: server['Mot de passe 3CX']
                        },
                        update_info: server.updateInfo
                    })
                });

                const result = await response.json();
                
                if (result.success) {
                    updateStatus(serverIndex, 'Mise à jour lancée', 'status-updated');
                    showAlert(`Mise à jour lancée pour le serveur ${serverIndex + 1}. Le serveur va redémarrer.`, 'success');
                    document.getElementById(`actions-${serverIndex}`).innerHTML = `
                        <button class="btn btn-primary btn-sm" onclick="checkUpdate(${serverIndex})">
                            Revérifier
                        </button>
                    `;
                } else {
                    updateStatus(serverIndex, 'Échec mise à jour', 'status-error');
                    showAlert(`Échec de la mise à jour : ${result.message}`, 'error');
                    document.getElementById(`actions-${serverIndex}`).innerHTML = `
                        <button class="btn btn-success btn-sm" onclick="promptUpdate(${serverIndex})">
                            Réessayer
                        </button>
                    `;
                }
            } catch (error) {
                updateStatus(serverIndex, 'Erreur', 'status-error');
                showAlert('Erreur lors de la mise à jour', 'error');
            }
        }

        function closeModal() {
            document.getElementById('confirmModal').classList.remove('active');
            currentUpdateServer = null;
        }

        function closeBulkModal() {
            document.getElementById('bulkModal').classList.remove('active');
            document.getElementById('progressContainer').style.display = 'none';
            document.getElementById('bulkModalFooter').style.display = 'flex';
            document.getElementById('progressFill').style.width = '0%';
            document.getElementById('progressText').textContent = '0 / 0';
            currentBulkAction = null;
            bulkProcessing = false;
        }

        function showAlert(message, type) {
            const alertContainer = document.getElementById('alertContainer');
            const alertClass = `alert-${type}`;
            
            const alert = document.createElement('div');
            alert.className = `alert ${alertClass}`;
            alert.textContent = message;
            
            alertContainer.innerHTML = '';
            alertContainer.appendChild(alert);
            
            setTimeout(() => {
                alert.style.opacity = '0';
                setTimeout(() => alert.remove(), 300);
            }, 5000);
        }

        // Fermer les modals avec Escape
        document.addEventListener('keydown', (e) => {
            if (e.key === 'Escape') {
                if (!bulkProcessing) {
                    closeModal();
                    closeBulkModal();
                }
            }
        });

        // Fonctions pour la gestion des services
        async function viewServices(serverIndex) {
            currentServicesIndex = serverIndex;
            const server = serversData[serverIndex];
            
            document.getElementById('servicesServerUrl').textContent = server['URL Web 3CX'];
            document.getElementById('servicesModal').classList.add('active');
            document.getElementById('servicesContent').innerHTML = `
                <div class="services-loading">
                    <div class="loading-spinner"></div>
                    <p style="margin-top: 10px;">Chargement des services...</p>
                </div>
            `;
            
            await loadServices(serverIndex);
        }

        async function loadServices(serverIndex) {
            const server = serversData[serverIndex];
            
            try {
                const response = await fetch('3cx_api.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                    },
                    body: JSON.stringify({
                        action: 'get_services',
                        server: {
                            url: server['URL Web 3CX'],
                            username: server['Identifiant 3CX'],
                            password: server['Mot de passe 3CX']
                        }
                    })
                });

                const result = await response.json();
                
                if (result.success && result.services) {
                    displayServices(result.services);
                } else {
                    document.getElementById('servicesContent').innerHTML = `
                        <div class="services-error">
                            <p>❌ Erreur lors du chargement des services</p>
                            <p style="font-size: 14px; margin-top: 10px;">${result.message || 'Erreur inconnue'}</p>
                        </div>
                    `;
                }
            } catch (error) {
                document.getElementById('servicesContent').innerHTML = `
                    <div class="services-error">
                        <p>❌ Erreur de connexion</p>
                        <p style="font-size: 14px; margin-top: 10px;">${error.message}</p>
                    </div>
                `;
            }
        }

        function displayServices(services) {
            let html = '<div class="services-grid">';
            
            services.forEach(service => {
                const isRunning = service.Status === 'Running';
                const statusClass = isRunning ? 'running' : 'stopped';
                const statusText = isRunning ? 'En cours' : 'Arrêté';
                
                // Convertir la mémoire en MB
                const memoryMB = (service.MemoryUsed / (1024 * 1024)).toFixed(2);
                
                html += `
                    <div class="service-card">
                        <div class="service-header">
                            <div>
                                <div class="service-name">${service.Name}</div>
                                <div class="service-display-name">${service.DisplayName}</div>
                            </div>
                            <div class="service-status ${statusClass}">
                                <span class="status-dot ${statusClass}"></span>
                                ${statusText}
                            </div>
                        </div>
                        <div class="service-info">
                            <div class="service-metric">
                                <span class="service-metric-label">Mémoire</span>
                                <span class="service-metric-value">${memoryMB} MB</span>
                            </div>
                            <div class="service-metric">
                                <span class="service-metric-label">CPU</span>
                                <span class="service-metric-value">${service.CpuUsage}%</span>
                            </div>
                            <div class="service-metric">
                                <span class="service-metric-label">Threads</span>
                                <span class="service-metric-value">${service.ThreadCount}</span>
                            </div>
                        </div>
                        ${service.RestartEnabled ? `
                            <div class="service-actions">
                                <button class="btn-restart" onclick="restartService('${service.Name}')" id="restart-${service.Name}">
                                    <svg fill="currentColor" viewBox="0 0 24 24" style="width: 14px; height: 14px;">
                                        <path d="M17.65,6.35C16.2,4.9 14.21,4 12,4A8,8 0 0,0 4,12A8,8 0 0,0 12,20C15.73,20 18.84,17.45 19.73,14H17.65C16.83,16.33 14.61,18 12,18A6,6 0 0,1 6,12A6,6 0 0,1 12,6C13.66,6 15.14,6.69 16.22,7.78L13,11H20V4L17.65,6.35Z"/>
                                    </svg>
                                    Redémarrer
                                </button>
                            </div>
                        ` : ''}
                    </div>
                `;
            });
            
            html += '</div>';
            document.getElementById('servicesContent').innerHTML = html;
        }

        async function restartService(serviceName) {
            if (!confirm(`Êtes-vous sûr de vouloir redémarrer le service "${serviceName}" ?`)) {
                return;
            }
            
            const button = document.getElementById(`restart-${serviceName}`);
            const originalText = button.innerHTML;
            button.disabled = true;
            button.innerHTML = '<div class="loading-spinner" style="width: 14px; height: 14px; border-width: 2px;"></div> Redémarrage...';
            
            const server = serversData[currentServicesIndex];
            
            try {
                const response = await fetch('3cx_api.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                    },
                    body: JSON.stringify({
                        action: 'restart_service',
                        server: {
                            url: server['URL Web 3CX'],
                            username: server['Identifiant 3CX'],
                            password: server['Mot de passe 3CX']
                        },
                        service_name: serviceName
                    })
                });

                const result = await response.json();
                
                if (result.success) {
                    showAlert(`✅ Service "${serviceName}" redémarré avec succès`, 'success');
                    // Recharger la liste après 2 secondes
                    setTimeout(() => {
                        loadServices(currentServicesIndex);
                    }, 2000);
                } else {
                    showAlert(`❌ Erreur lors du redémarrage : ${result.message}`, 'error');
                    button.disabled = false;
                    button.innerHTML = originalText;
                }
            } catch (error) {
                showAlert(`❌ Erreur de connexion : ${error.message}`, 'error');
                button.disabled = false;
                button.innerHTML = originalText;
            }
        }

        function refreshServices() {
            if (currentServicesIndex !== null) {
                loadServices(currentServicesIndex);
            }
        }

        function closeServicesModal() {
            document.getElementById('servicesModal').classList.remove('active');
            currentServicesIndex = null;
        }

        // Fonctions pour le template CSV et le guide
        function downloadTemplate() {
            const template = 'URL Web 3CX,Identifiant 3CX,Mot de passe 3CX\n' +
                           'https://3cx.exemple.com,admin,MotDePasse123!\n' +
                           'https://192.168.1.100,administrator,SecurePass456\n' +
                           'https://pbx.client.fr:5001,admin,P@ssw0rd789';
            
            const blob = new Blob([template], { type: 'text/csv;charset=utf-8;' });
            const link = document.createElement('a');
            const url = URL.createObjectURL(blob);
            
            link.setAttribute('href', url);
            link.setAttribute('download', 'template_3cx_servers.csv');
            link.style.visibility = 'hidden';
            
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);
            
            showAlert('✅ Template CSV téléchargé avec succès', 'success');
        }

        function showGuide() {
            document.getElementById('guideModal').classList.add('active');
        }

        function closeGuideModal() {
            document.getElementById('guideModal').classList.remove('active');
        }

        // Fonctions pour le dashboard
        function toggleDashboard() {
            const dashboard = document.getElementById('dashboardContainer');
            dashboard.classList.toggle('active');
            
            if (dashboard.classList.contains('active')) {
                updateDashboard();
                initCharts();
            }
        }

        function updateDashboard() {
            const stats = {
                total: serversData.length,
                updated: 0,
                available: 0,
                error: 0,
                pending: 0
            };
            
            serversData.forEach((_, index) => {
                const row = document.getElementById(`server-row-${index}`);
                if (!row) return;
                
                const status = row.dataset.status;
                switch(status) {
                    case 'updated':
                        stats.updated++;
                        break;
                    case 'available':
                        stats.available++;
                        break;
                    case 'error':
                        stats.error++;
                        break;
                    case 'pending':
                    case 'checking':
                        stats.pending++;
                        break;
                }
            });
            
            // Mettre à jour les cartes de statistiques
            document.getElementById('statTotal').textContent = stats.total;
            document.getElementById('statUpdated').textContent = stats.updated;
            document.getElementById('statAvailable').textContent = stats.available;
            document.getElementById('statError').textContent = stats.error;
            document.getElementById('statPending').textContent = stats.pending;
            
            // Mettre à jour les graphiques si initialisés
            if (statusChart) {
                updateCharts(stats);
            }
        }

        function initCharts() {
            // Détruire les graphiques existants s'ils existent
            if (statusChart) {
                statusChart.destroy();
                statusChart = null;
            }
            if (progressChart) {
                progressChart.destroy();
                progressChart = null;
            }
            
            // Graphique en camembert pour la répartition
            const ctxStatus = document.getElementById('statusChart').getContext('2d');
            statusChart = new Chart(ctxStatus, {
                type: 'doughnut',
                data: {
                    labels: ['À jour', 'Mises à jour disponibles', 'Erreurs', 'Non vérifiés'],
                    datasets: [{
                        data: [0, 0, 0, 0],
                        backgroundColor: [
                            'rgba(40, 167, 69, 0.8)',
                            'rgba(255, 193, 7, 0.8)',
                            'rgba(220, 53, 69, 0.8)',
                            'rgba(108, 117, 125, 0.8)'
                        ],
                        borderColor: [
                            'rgba(40, 167, 69, 1)',
                            'rgba(255, 193, 7, 1)',
                            'rgba(220, 53, 69, 1)',
                            'rgba(108, 117, 125, 1)'
                        ],
                        borderWidth: 2
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    animation: {
                        animateRotate: true,
                        animateScale: false
                    },
                    plugins: {
                        legend: {
                            position: 'bottom',
                            labels: {
                                padding: 15,
                                font: {
                                    size: 12
                                }
                            }
                        },
                        tooltip: {
                            callbacks: {
                                label: function(context) {
                                    const label = context.label || '';
                                    const value = context.parsed || 0;
                                    const total = context.dataset.data.reduce((a, b) => a + b, 0);
                                    const percentage = total > 0 ? ((value / total) * 100).toFixed(1) : 0;
                                    return `${label}: ${value} (${percentage}%)`;
                                }
                            }
                        }
                    }
                }
            });
            
            // Graphique en barres pour la progression
            const ctxProgress = document.getElementById('progressChart').getContext('2d');
            progressChart = new Chart(ctxProgress, {
                type: 'bar',
                data: {
                    labels: ['Vérifiés', 'Non vérifiés'],
                    datasets: [{
                        label: 'Nombre de serveurs',
                        data: [0, 0],
                        backgroundColor: [
                            'rgba(28, 109, 158, 0.8)',
                            'rgba(200, 200, 200, 0.8)'
                        ],
                        borderColor: [
                            'rgba(28, 109, 158, 1)',
                            'rgba(150, 150, 150, 1)'
                        ],
                        borderWidth: 2
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    indexAxis: 'y',
                    plugins: {
                        legend: {
                            display: false
                        }
                    },
                    scales: {
                        x: {
                            beginAtZero: true,
                            ticks: {
                                stepSize: 1,
                                precision: 0
                            }
                        }
                    }
                }
            });
            
            updateDashboard();
        }

        function updateCharts(stats) {
            if (statusChart) {
                statusChart.data.datasets[0].data = [
                    stats.updated,
                    stats.available,
                    stats.error,
                    stats.pending
                ];
                statusChart.update('none'); // Pas d'animation lors de la mise à jour
            }
            
            if (progressChart) {
                const verified = stats.updated + stats.available + stats.error;
                const notVerified = stats.pending;
                progressChart.data.datasets[0].data = [verified, notVerified];
                progressChart.update('none'); // Pas d'animation lors de la mise à jour
            }
        }
    </script>
</body>
</html>
