<?php
session_start();

// Gérer le téléchargement EN PREMIER (avant tout affichage HTML)
if (isset($_GET['download'])) {
    if (isset($_SESSION['converted_file']) && file_exists($_SESSION['converted_file'])) {
        $filePath = $_SESSION['converted_file'];
        $fileName = $_SESSION['converted_filename'];
        
        // Nettoyer le buffer de sortie
        if (ob_get_level()) {
            ob_end_clean();
        }
        
        header('Content-Type: audio/wav');
        header('Content-Disposition: attachment; filename="' . $fileName . '"');
        header('Content-Length: ' . filesize($filePath));
        header('Cache-Control: no-cache, must-revalidate');
        header('Pragma: no-cache');
        
        readfile($filePath);
        
        // Nettoyer le fichier temporaire
        unlink($filePath);
        unset($_SESSION['converted_file']);
        unset($_SESSION['converted_filename']);
        exit;
    }
}

$message = '';
$messageType = '';

// Traiter l'upload et la conversion
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['audio_file'])) {
    $uploadedFile = $_FILES['audio_file'];
    
    if ($uploadedFile['error'] !== UPLOAD_ERR_OK) {
        $message = "Erreur lors de l'upload du fichier.";
        $messageType = 'error';
    } else {
        $inputFile = $uploadedFile['tmp_name'];
        $originalName = pathinfo($uploadedFile['name'], PATHINFO_FILENAME);
        $outputFile = sys_get_temp_dir() . '/' . $originalName . '_converted_' . time() . '.wav';
        
        $command = sprintf(
            'ffmpeg -i %s -ar 8000 -ac 1 -sample_fmt s16 -y %s 2>&1',
            escapeshellarg($inputFile),
            escapeshellarg($outputFile)
        );
        
        exec($command, $output, $returnCode);
        
        if ($returnCode === 0 && file_exists($outputFile)) {
            $message = "✓ Conversion réussie ! Votre fichier est prêt.";
            $messageType = 'success';
            
            $_SESSION['converted_file'] = $outputFile;
            $_SESSION['converted_filename'] = $originalName . '_converted.wav';
        } else {
            $message = "Erreur lors de la conversion. Assurez-vous que FFmpeg est installé sur le serveur.";
            $messageType = 'error';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Convertisseur Audio - WAV Mono 8kHz 16bit</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        .container {
            background: white;
            border-radius: 15px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            padding: 40px;
            max-width: 600px;
            width: 100%;
        }
        
        h1 {
            color: #333;
            margin-bottom: 10px;
            font-size: 28px;
            text-align: center;
        }
        
        .specs {
            background: #f8f9fa;
            border-left: 4px solid #667eea;
            padding: 15px;
            margin: 20px 0;
            border-radius: 5px;
        }
        
        .specs h3 {
            color: #667eea;
            margin-bottom: 10px;
            font-size: 16px;
        }
        
        .specs ul {
            list-style: none;
            color: #555;
        }
        
        .specs li {
            padding: 5px 0;
            font-size: 14px;
        }
        
        .specs li:before {
            content: "✓ ";
            color: #667eea;
            font-weight: bold;
            margin-right: 5px;
        }
        
        .upload-area {
            border: 3px dashed #ddd;
            border-radius: 10px;
            padding: 40px;
            text-align: center;
            margin: 20px 0;
            background: #fafafa;
            transition: all 0.3s;
        }
        
        .upload-area:hover {
            border-color: #667eea;
            background: #f0f4ff;
        }
        
        input[type="file"] {
            display: none;
        }
        
        .file-label {
            display: inline-block;
            padding: 12px 30px;
            background: #667eea;
            color: white;
            border-radius: 25px;
            cursor: pointer;
            font-weight: 600;
            transition: all 0.3s;
        }
        
        .file-label:hover {
            background: #764ba2;
            transform: translateY(-2px);
        }
        
        .file-name {
            margin-top: 15px;
            color: #666;
            font-size: 14px;
        }
        
        button[type="submit"] {
            width: 100%;
            padding: 15px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            border-radius: 25px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
            margin-top: 20px;
        }
        
        button[type="submit"]:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 20px rgba(102, 126, 234, 0.4);
        }
        
        button[type="submit"]:disabled {
            background: #ccc;
            cursor: not-allowed;
            transform: none;
        }
        
        .message {
            padding: 15px;
            border-radius: 8px;
            margin: 20px 0;
            text-align: center;
        }
        
        .success {
            background: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }
        
        .error {
            background: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }
        
        .download-btn {
            display: inline-block;
            padding: 12px 30px;
            background: #28a745;
            color: white;
            text-decoration: none;
            border-radius: 25px;
            margin-top: 10px;
            font-weight: 600;
            transition: all 0.3s;
        }
        
        .download-btn:hover {
            background: #218838;
            transform: translateY(-2px);
        }
        
        .info {
            background: #d1ecf1;
            color: #0c5460;
            padding: 12px;
            border-radius: 8px;
            margin: 15px 0;
            font-size: 13px;
            text-align: center;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>🎵 Convertisseur Audio</h1>
        
        <div class="specs">
            <h3>Format de sortie :</h3>
            <ul>
                <li>Format: WAV</li>
                <li>Canal: Mono</li>
                <li>Taux d'échantillonnage: 8 kHz</li>
                <li>Échantillonnage: 16 bit</li>
            </ul>
        </div>

        <?php if ($message): ?>
            <div class="message <?php echo $messageType; ?>">
                <?php echo htmlspecialchars($message); ?>
                <?php if ($messageType === 'success'): ?>
                    <br>
                    <a href="?download=1" class="download-btn">📥 Télécharger le fichier</a>
                <?php endif; ?>
            </div>
        <?php endif; ?>

        <div class="info">
            ℹ️ Formats acceptés : MP3, WAV, OGG, FLAC, M4A, AAC, WMA, etc.
        </div>

        <form method="POST" enctype="multipart/form-data" id="uploadForm">
            <div class="upload-area">
                <label for="audio_file" class="file-label">
                    📁 Choisir un fichier audio
                </label>
                <input type="file" 
                       id="audio_file" 
                       name="audio_file" 
                       accept="audio/*"
                       required
                       onchange="updateFileName(this)">
                <div class="file-name" id="fileName">Aucun fichier sélectionné</div>
            </div>
            
            <button type="submit" id="submitBtn">
                🔄 Convertir en WAV Mono 8kHz 16bit
            </button>
        </form>
    </div>

    <script>
        function updateFileName(input) {
            const fileName = document.getElementById('fileName');
            if (input.files && input.files[0]) {
                fileName.textContent = '✓ ' + input.files[0].name;
                fileName.style.color = '#667eea';
                fileName.style.fontWeight = '600';
            } else {
                fileName.textContent = 'Aucun fichier sélectionné';
                fileName.style.color = '#666';
                fileName.style.fontWeight = 'normal';
            }
        }

        document.getElementById('uploadForm').addEventListener('submit', function() {
            const btn = document.getElementById('submitBtn');
            btn.disabled = true;
            btn.textContent = '⏳ Conversion en cours...';
        });
    </script>
</body>
</html>
