<?php
require_once __DIR__ . '/config.php';

// Récupérer les informations de session
$playerId = $_SESSION['player_id'] ?? null;
$gameCode = $_SESSION['game_code'] ?? null;

// Si le joueur était dans une partie
if ($playerId && $gameCode) {
    $game = loadGame($gameCode);
    
    if ($game && isset($game['players'][$playerId])) {
        // Retirer le joueur de la partie
        unset($game['players'][$playerId]);
        
        // Si c'était l'hôte, transférer le rôle
        if ($game['host'] === $playerId && !empty($game['players'])) {
            $game['host'] = array_key_first($game['players']);
        }
        
        // Si plus de joueurs, supprimer la partie
        if (empty($game['players'])) {
            unlink(getGameFilePath($gameCode));
        } else {
            $game['updatedAt'] = time();
            saveGame($gameCode, $game);
        }
    }
}

// Nettoyer la session
unset($_SESSION['player_id'], $_SESSION['game_code'], $_SESSION['player_name']);

// Rediriger vers l'accueil
header('Location: index.php');
exit;
